/*
 * Decompiled with CFR 0.152.
 */
package org.nlab.smtp.transport.factory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.event.TransportListener;
import org.nlab.smtp.transport.factory.SmtpConnectionFactory;
import org.nlab.smtp.transport.strategy.ConnectionStrategy;
import org.nlab.smtp.transport.strategy.ConnectionStrategyFactory;
import org.nlab.smtp.transport.strategy.TransportStrategy;
import org.nlab.smtp.transport.strategy.TransportStrategyFactory;

public class SmtpConnectionFactoryBuilder {
    protected Session session = null;
    protected String protocol = null;
    protected String host = null;
    protected int port = -1;
    protected String username;
    protected String password;
    protected boolean invalidateConnectionOnException;
    protected List<TransportListener> defaultTransportListeners = Collections.emptyList();

    private SmtpConnectionFactoryBuilder() {
    }

    public static SmtpConnectionFactoryBuilder newSmtpBuilder() {
        return new SmtpConnectionFactoryBuilder();
    }

    public SmtpConnectionFactoryBuilder session(Properties properties) {
        this.session = Session.getInstance((Properties)properties);
        return this;
    }

    public SmtpConnectionFactoryBuilder session(Properties properties, Authenticator authenticator) {
        this.session = Session.getInstance((Properties)properties, (Authenticator)authenticator);
        return this;
    }

    public SmtpConnectionFactoryBuilder session(Session session) {
        this.session = Objects.requireNonNull(session);
        return this;
    }

    public SmtpConnectionFactoryBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public SmtpConnectionFactoryBuilder host(String host) {
        this.host = host;
        return this;
    }

    public SmtpConnectionFactoryBuilder port(int port) {
        this.port = port;
        return this;
    }

    public SmtpConnectionFactoryBuilder username(String username) {
        this.username = username;
        return this;
    }

    public SmtpConnectionFactoryBuilder password(String password) {
        this.password = password;
        return this;
    }

    public SmtpConnectionFactoryBuilder defaultTransportListeners(TransportListener ... listeners) {
        this.defaultTransportListeners = Arrays.asList((Object[])Objects.requireNonNull(listeners));
        return this;
    }

    public SmtpConnectionFactoryBuilder invalidateConnectionOnException(boolean invalidateConnectionOnException) {
        this.invalidateConnectionOnException = invalidateConnectionOnException;
        return this;
    }

    public SmtpConnectionFactory build() {
        if (this.session == null) {
            this.session = Session.getInstance((Properties)new Properties());
        }
        TransportStrategy transportStrategy = this.protocol == null ? TransportStrategyFactory.newSessiontStrategy() : TransportStrategyFactory.newProtocolStrategy(this.protocol);
        ConnectionStrategy connectionStrategy = this.host == null && this.port == -1 && this.username == null && this.password == null ? ConnectionStrategyFactory.newConnectionStrategy() : ConnectionStrategyFactory.newConnectionStrategy(this.host, this.port, this.username, this.password);
        return new SmtpConnectionFactory(this.session, transportStrategy, connectionStrategy, this.invalidateConnectionOnException, this.defaultTransportListeners);
    }
}

