/*
 * Decompiled with CFR 0.152.
 */
package org.nlab.smtp.pool;

import jakarta.mail.Session;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.nlab.smtp.pool.ObjectPoolAware;
import org.nlab.smtp.transport.connection.ClosableSmtpConnection;
import org.nlab.smtp.transport.factory.SmtpConnectionFactory;

public class SmtpConnectionPool
extends GenericObjectPool<ClosableSmtpConnection> {
    public SmtpConnectionPool(SmtpConnectionFactory factory) {
        super((PooledObjectFactory)factory);
    }

    public SmtpConnectionPool(SmtpConnectionFactory factory, GenericObjectPoolConfig config) {
        super((PooledObjectFactory)factory, config);
    }

    public SmtpConnectionPool(SmtpConnectionFactory factory, GenericObjectPoolConfig config, AbandonedConfig abandonedConfig) {
        super((PooledObjectFactory)factory, config, abandonedConfig);
    }

    public ClosableSmtpConnection borrowObject() throws Exception {
        ClosableSmtpConnection object = (ClosableSmtpConnection)super.borrowObject();
        if (object instanceof ObjectPoolAware) {
            ((ObjectPoolAware)((Object)object)).setObjectPool(this);
        }
        return object;
    }

    public ClosableSmtpConnection borrowObject(long borrowMaxWaitMillis) throws Exception {
        ClosableSmtpConnection object = (ClosableSmtpConnection)super.borrowObject(borrowMaxWaitMillis);
        if (object instanceof ObjectPoolAware) {
            ((ObjectPoolAware)((Object)object)).setObjectPool(this);
        }
        return object;
    }

    public Session getSession() {
        return ((SmtpConnectionFactory)this.getFactory()).getSession();
    }
}

