/*
 * Decompiled with CFR 0.152.
 */
package org.nlab.smtp.transport.connection;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.event.TransportListener;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.nlab.smtp.exception.MailSendException;
import org.nlab.smtp.pool.ObjectPoolAware;
import org.nlab.smtp.pool.SmtpConnectionPool;
import org.nlab.smtp.transport.connection.ClosableSmtpConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClosableSmtpConnection
implements ClosableSmtpConnection,
ObjectPoolAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClosableSmtpConnection.class);
    private final Transport delegate;
    private SmtpConnectionPool objectPool;
    private boolean invalidateConnectionOnException;
    private boolean invalidateConnectionOnClose;
    private final List<TransportListener> transportListeners = new ArrayList<TransportListener>();

    public DefaultClosableSmtpConnection(Transport delegate, boolean invalidateConnectionOnException) {
        this.delegate = delegate;
        this.invalidateConnectionOnException = invalidateConnectionOnException;
    }

    @Override
    public void invalidate() {
        this.invalidateConnectionOnClose = true;
    }

    @Override
    public void setInvalidateConnectionOnClose(boolean invalidateConnectionOnClose) {
        this.invalidateConnectionOnClose = invalidateConnectionOnClose;
    }

    @Override
    public void sendMessage(MimeMessage msg, Address[] recipients) throws MessagingException {
        this.doSend(msg, recipients);
    }

    @Override
    public void sendMessage(MimeMessage msg) throws MessagingException {
        this.doSend(msg, msg.getAllRecipients());
    }

    @Override
    public void sendMessages(MimeMessage ... msgs) throws MailSendException {
        this.doSend(msgs);
    }

    @Override
    public void addTransportListener(TransportListener l) {
        this.transportListeners.add(l);
        this.delegate.addTransportListener(l);
    }

    @Override
    public void removeTransportListener(TransportListener l) {
        this.transportListeners.remove(l);
        this.delegate.removeTransportListener(l);
    }

    @Override
    public void clearListeners() {
        for (TransportListener transportListener : this.transportListeners) {
            this.delegate.removeTransportListener(transportListener);
        }
        this.transportListeners.clear();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public void close() {
        if (!this.invalidateConnectionOnClose) {
            this.objectPool.returnObject(this);
        } else {
            try {
                this.objectPool.invalidateObject(this);
            }
            catch (Exception e) {
                LOG.error("Failed to invalidate object in the pool", (Throwable)e);
            }
        }
    }

    @Override
    public void setObjectPool(SmtpConnectionPool objectPool) {
        this.objectPool = objectPool;
    }

    @Override
    public SmtpConnectionPool getObjectPool() {
        return this.objectPool;
    }

    @Override
    public Transport getDelegate() {
        return this.delegate;
    }

    @Override
    public Session getSession() {
        return this.objectPool.getSession();
    }

    private void doSend(MimeMessage mimeMessage, Address[] recipients) throws MessagingException {
        try {
            if (mimeMessage.getSentDate() == null) {
                mimeMessage.setSentDate(new Date());
            }
            String messageId = mimeMessage.getMessageID();
            mimeMessage.saveChanges();
            if (messageId != null) {
                mimeMessage.setHeader("Message-ID", messageId);
            }
            this.delegate.sendMessage((Message)mimeMessage, recipients);
        }
        catch (Exception e) {
            if (this.invalidateConnectionOnException) {
                this.invalidate();
            }
            throw e;
        }
    }

    private void doSend(MimeMessage ... mimeMessages) throws MailSendException {
        LinkedHashMap<Object, Exception> failedMessages = new LinkedHashMap<Object, Exception>();
        for (MimeMessage mimeMessage : mimeMessages) {
            try {
                this.doSend(mimeMessage, mimeMessage.getAllRecipients());
            }
            catch (Exception ex) {
                failedMessages.put(mimeMessage, ex);
            }
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }
}

