/*
 * Decompiled with CFR 0.152.
 */
package org.nlab.smtp.transport.factory;

import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.event.TransportListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.nlab.smtp.transport.connection.ClosableSmtpConnection;
import org.nlab.smtp.transport.connection.DefaultClosableSmtpConnection;
import org.nlab.smtp.transport.strategy.ConnectionStrategy;
import org.nlab.smtp.transport.strategy.TransportStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpConnectionFactory
implements PooledObjectFactory<ClosableSmtpConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(SmtpConnectionFactory.class);
    protected final Session session;
    protected final TransportStrategy transportFactory;
    protected final ConnectionStrategy connectionStrategy;
    protected final boolean invalidateConnectionOnException;
    protected List<TransportListener> defaultTransportListeners;

    public SmtpConnectionFactory(Session session, TransportStrategy transportStrategy, ConnectionStrategy connectionStrategy, boolean invalidateConnectionOnException, Collection<TransportListener> defaultTransportListeners) {
        this.session = session;
        this.transportFactory = transportStrategy;
        this.connectionStrategy = connectionStrategy;
        this.invalidateConnectionOnException = invalidateConnectionOnException;
        this.defaultTransportListeners = new ArrayList<TransportListener>(defaultTransportListeners);
    }

    public SmtpConnectionFactory(Session session, TransportStrategy transportFactory, ConnectionStrategy connectionStrategy, boolean invalidateConnectionOnException) {
        this(session, transportFactory, connectionStrategy, invalidateConnectionOnException, Collections.emptyList());
    }

    public PooledObject<ClosableSmtpConnection> makeObject() throws Exception {
        LOG.debug("makeObject");
        Transport transport = this.transportFactory.getTransport(this.session);
        this.connectionStrategy.connect(transport);
        DefaultClosableSmtpConnection closableSmtpTransport = new DefaultClosableSmtpConnection(transport, this.invalidateConnectionOnException);
        this.initDefaultListeners(closableSmtpTransport);
        return new DefaultPooledObject((Object)closableSmtpTransport);
    }

    public void destroyObject(PooledObject<ClosableSmtpConnection> pooledObject) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("destroyObject [{}]", (Object)((ClosableSmtpConnection)pooledObject.getObject()).isConnected());
            }
            ((ClosableSmtpConnection)pooledObject.getObject()).clearListeners();
            ((ClosableSmtpConnection)pooledObject.getObject()).getDelegate().close();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    public boolean validateObject(PooledObject<ClosableSmtpConnection> pooledObject) {
        boolean connected = ((ClosableSmtpConnection)pooledObject.getObject()).isConnected();
        LOG.debug("Is connected [{}]", (Object)connected);
        return connected;
    }

    public void activateObject(PooledObject<ClosableSmtpConnection> pooledObject) throws Exception {
        this.initDefaultListeners((ClosableSmtpConnection)pooledObject.getObject());
    }

    public void passivateObject(PooledObject<ClosableSmtpConnection> pooledObject) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("passivateObject [{}]", (Object)((ClosableSmtpConnection)pooledObject.getObject()).isConnected());
        }
        ((ClosableSmtpConnection)pooledObject.getObject()).clearListeners();
    }

    public List<TransportListener> getDefaultListeners() {
        return Collections.unmodifiableList(this.defaultTransportListeners);
    }

    public boolean isInvalidateConnectionOnException() {
        return this.invalidateConnectionOnException;
    }

    public Session getSession() {
        return this.session;
    }

    public TransportStrategy getTransportFactory() {
        return this.transportFactory;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    private void initDefaultListeners(ClosableSmtpConnection smtpTransport) {
        for (TransportListener transportListener : this.defaultTransportListeners) {
            smtpTransport.addTransportListener(transportListener);
        }
    }
}

