/*
 * Decompiled with CFR 0.152.
 */
package com.github.ydoc.swagger;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.ydoc.anno.ParamDesc;
import com.github.ydoc.anno.ParamIgnore;
import com.github.ydoc.swagger.Factory;
import com.github.ydoc.yapi.RequestBodyType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class RequestTypeMatchingSwagger {
    public static JSONObject matching(JSONObject json, Method method, String outPath, String tag) {
        if (method.isAnnotationPresent(GetMapping.class)) {
            GetMapping getMapping = method.getAnnotation(GetMapping.class);
            String path = "";
            if (getMapping.value().length > 0) {
                path = getMapping.value()[0];
            }
            return RequestTypeMatchingSwagger.get(getMapping.name(), path, json, method, outPath, tag);
        }
        if (method.isAnnotationPresent(PostMapping.class)) {
            PostMapping annotation = method.getAnnotation(PostMapping.class);
            String path = "";
            if (annotation.value().length > 0) {
                path = annotation.value()[0];
            }
            return RequestTypeMatchingSwagger.post(annotation.name(), path, json, method, outPath, tag);
        }
        if (method.isAnnotationPresent(PutMapping.class)) {
            PutMapping annotation = method.getAnnotation(PutMapping.class);
            String path = "";
            if (annotation.value().length > 0) {
                path = annotation.value()[0];
            }
            return RequestTypeMatchingSwagger.put(annotation.name(), path, json, method, outPath, tag);
        }
        if (method.isAnnotationPresent(DeleteMapping.class)) {
            DeleteMapping annotation = method.getAnnotation(DeleteMapping.class);
            String path = "";
            if (annotation.value().length > 0) {
                path = annotation.value()[0];
            }
            return RequestTypeMatchingSwagger.delete(annotation.name(), path, json, method, outPath, tag);
        }
        if (method.isAnnotationPresent(RequestMapping.class)) {
            RequestMapping annotation = method.getAnnotation(RequestMapping.class);
            RequestMethod requestMethod = null;
            if (annotation.method().length > 0) {
                requestMethod = annotation.method()[0];
            }
            String path = "";
            if (annotation.value().length > 0) {
                path = annotation.value()[0];
            }
            if (requestMethod != null) {
                switch (requestMethod) {
                    case GET: {
                        return RequestTypeMatchingSwagger.get(requestMethod.name(), path, json, method, outPath, tag);
                    }
                    case PUT: {
                        return RequestTypeMatchingSwagger.put(requestMethod.name(), path, json, method, outPath, tag);
                    }
                    case POST: {
                        return RequestTypeMatchingSwagger.post(requestMethod.name(), path, json, method, outPath, tag);
                    }
                    case DELETE: {
                        return RequestTypeMatchingSwagger.delete(requestMethod.name(), path, json, method, outPath, tag);
                    }
                }
                return Factory.get();
            }
        } else {
            return new JSONObject();
        }
        return Factory.get();
    }

    public static void returnBuild(Method method, JSONObject json) {
        JSONObject res = Factory.get();
        json.put("responses", (Object)res);
        JSONObject resDetail = Factory.get();
        res.put("200", (Object)resDetail);
        resDetail.put("description", (Object)"successful operation");
        JSONObject schema = Factory.get();
        resDetail.put("schema", (Object)schema);
        schema.put("type", (Object)"object");
        schema.put("title", (Object)"YDoc");
        JSONObject properties = Factory.get();
        Class<?> returnType = method.getReturnType();
        String desc = returnType.getName();
        if (returnType.isAnnotationPresent(ParamDesc.class)) {
            ParamDesc annotation = returnType.getAnnotation(ParamDesc.class);
            desc = annotation.value();
        }
        if (returnType.equals(List.class) || returnType.equals(Set.class)) {
            schema.put("type", (Object)"array");
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                ParameterizedType genericReturnType1 = (ParameterizedType)genericReturnType;
                for (Type actualTypeArgument : genericReturnType1.getActualTypeArguments()) {
                    if (RequestTypeMatchingSwagger.checkJavaType(actualTypeArgument.getTypeName())) {
                        JSONObject jsonObject = Factory.get();
                        properties.put(actualTypeArgument.getTypeName(), (Object)jsonObject);
                        jsonObject.put("description", (Object)desc);
                        jsonObject.put("type", (Object)RequestBodyType.of((String)actualTypeArgument.getTypeName()).type);
                        schema.put("properties", (Object)properties);
                        continue;
                    }
                    try {
                        Class<?> clazz = Class.forName(actualTypeArgument.getTypeName());
                        for (Field declaredField : clazz.getDeclaredFields()) {
                            if (Modifier.isFinal(declaredField.getModifiers())) continue;
                            properties.put(declaredField.getName(), (Object)RequestTypeMatchingSwagger.deepObject(Factory.get(), declaredField));
                        }
                        schema.put("properties", (Object)properties);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (RequestTypeMatchingSwagger.checkJavaType(returnType.getName())) {
            schema.put("type", (Object)RequestBodyType.of((String)returnType.getSimpleName()).type);
            JSONObject jsonObject = Factory.get();
            properties.put(returnType.getSimpleName(), (Object)jsonObject);
            jsonObject.put("description", (Object)desc);
            jsonObject.put("type", (Object)RequestBodyType.of((String)returnType.getSimpleName()).type);
            schema.put("properties", (Object)properties);
        } else {
            for (Field declaredField : returnType.getDeclaredFields()) {
                properties.put(declaredField.getName(), (Object)RequestTypeMatchingSwagger.deepObject(Factory.get(), declaredField));
            }
            schema.put("properties", (Object)properties);
        }
    }

    private static JSONObject get(String name, String path, JSONObject api, Method method, String outPath, String tag) {
        Parameter[] parameters;
        JSONObject apiMethod = Factory.get();
        api.put(outPath + path, (Object)apiMethod);
        JSONObject content = Factory.get();
        apiMethod.put("get", (Object)content);
        content.put("summary", (Object)name);
        content.put("description", (Object)name);
        ArrayList<JSONObject> parametersJson = new ArrayList<JSONObject>();
        content.put("parameters", parametersJson);
        content.put("tags", Collections.singletonList(tag));
        RequestTypeMatchingSwagger.returnBuild(method, content);
        for (Parameter parameterType : parameters = method.getParameters()) {
            PathVariable annotation;
            if (parameterType.isAnnotationPresent(ParamIgnore.class)) continue;
            boolean isObject = Boolean.FALSE;
            JSONObject param = Factory.get();
            String paramName = parameterType.getName();
            String paramType = parameterType.getType().getSimpleName();
            String paramDesc = parameterType.getName();
            String in = "query";
            boolean required = Boolean.FALSE;
            if (parameterType.isAnnotationPresent(PathVariable.class)) {
                annotation = parameterType.getAnnotation(PathVariable.class);
                paramName = annotation.value();
                required = Boolean.TRUE;
                paramDesc = StringUtils.hasText((String)annotation.name()) ? annotation.name() : "path\u53c2\u6570";
                paramType = "string";
                in = "path";
            } else if (parameterType.isAnnotationPresent(RequestParam.class)) {
                annotation = parameterType.getAnnotation(RequestParam.class);
                paramName = annotation.value();
                paramDesc = annotation.name();
                required = annotation.required();
            } else {
                if (parameterType.getDeclaredAnnotations().length > 1) continue;
                if (!RequestTypeMatchingSwagger.checkJavaType(parameterType.getParameterizedType().getTypeName())) {
                    Field[] declaredFields;
                    isObject = Boolean.TRUE;
                    for (Field field : declaredFields = parameterType.getType().getDeclaredFields()) {
                        if (Modifier.isFinal(field.getModifiers())) continue;
                        JSONObject bodyField = Factory.get();
                        bodyField.put("name", (Object)field.getName());
                        bodyField.put("in", (Object)"query");
                        bodyField.put("type", (Object)RequestBodyType.of((String)field.getType().getSimpleName()).type);
                        if (field.isAnnotationPresent(ParamDesc.class)) {
                            ParamDesc annotation2 = field.getAnnotation(ParamDesc.class);
                            bodyField.put("required", (Object)annotation2.required());
                            bodyField.put("description", (Object)annotation2.value());
                        } else {
                            bodyField.put("required", (Object)Boolean.TRUE);
                            bodyField.put("description", (Object)field.getName());
                        }
                        parametersJson.add(bodyField);
                    }
                }
            }
            if (isObject) continue;
            param.put("name", (Object)paramName);
            param.put("in", (Object)in);
            param.put("required", (Object)required);
            param.put("description", (Object)paramDesc);
            param.put("type", (Object)RequestBodyType.of((String)paramType).type);
            parametersJson.add(param);
        }
        return api;
    }

    private static JSONObject post(String name, String path, JSONObject api, Method method, String outPath, String tag) {
        JSONObject apiMethod = Factory.get();
        api.put(outPath + path, (Object)apiMethod);
        JSONObject content = Factory.get();
        apiMethod.put("post", (Object)content);
        content.put("tags", Collections.singletonList(tag));
        content.put("summary", (Object)name);
        content.put("description", (Object)name);
        content.put("consumes", Collections.singleton("application/json"));
        ArrayList<JSONObject> parametersJson = new ArrayList<JSONObject>();
        content.put("parameters", parametersJson);
        RequestTypeMatchingSwagger.returnBuild(method, content);
        RequestTypeMatchingSwagger.baseRequestBody(method.getParameters(), parametersJson);
        return api;
    }

    private static JSONObject delete(String name, String path, JSONObject api, Method method, String outPath, String tag) {
        JSONObject apiMethod = Factory.get();
        api.put(outPath + path, (Object)apiMethod);
        JSONObject content = Factory.get();
        apiMethod.put("delete", (Object)content);
        content.put("tags", Collections.singletonList(tag));
        content.put("summary", (Object)name);
        content.put("description", (Object)name);
        content.put("consumes", Collections.singleton("application/json"));
        ArrayList<JSONObject> parametersJson = new ArrayList<JSONObject>();
        content.put("parameters", parametersJson);
        RequestTypeMatchingSwagger.returnBuild(method, content);
        RequestTypeMatchingSwagger.baseRequestBody(method.getParameters(), parametersJson);
        return api;
    }

    private static JSONObject put(String name, String path, JSONObject api, Method method, String outPath, String tag) {
        JSONObject apiMethod = Factory.get();
        api.put(outPath + path, (Object)apiMethod);
        JSONObject content = Factory.get();
        apiMethod.put("put", (Object)content);
        content.put("tags", Collections.singletonList(tag));
        content.put("summary", (Object)name);
        content.put("description", (Object)name);
        content.put("consumes", Collections.singleton("application/json"));
        ArrayList<JSONObject> parametersJson = new ArrayList<JSONObject>();
        content.put("parameters", parametersJson);
        RequestTypeMatchingSwagger.returnBuild(method, content);
        RequestTypeMatchingSwagger.baseRequestBody(method.getParameters(), parametersJson);
        return api;
    }

    private static void baseRequestBody(Parameter[] parameters, List<JSONObject> list) {
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(PathVariable.class)) {
                PathVariable annotation = parameter.getAnnotation(PathVariable.class);
                JSONObject api = Factory.get();
                api.put("name", (Object)annotation.value());
                api.put("in", (Object)"path");
                api.put("required", (Object)Boolean.TRUE);
                api.put("description", (Object)(StringUtils.hasText((String)annotation.name()) ? annotation.name() : "path\u53c2\u6570"));
                api.put("type", (Object)"string");
                list.add(api);
                continue;
            }
            if (!parameter.isAnnotationPresent(RequestBody.class)) continue;
            Class<?> type = parameter.getType();
            Field[] declaredFields = type.getDeclaredFields();
            JSONObject api = Factory.get();
            api.put("name", (Object)"root");
            api.put("in", (Object)"body");
            JSONObject schema = Factory.get();
            api.put("schema", (Object)schema);
            schema.put("type", (Object)"object");
            schema.put("title", (Object)type.getSimpleName());
            JSONObject properties = Factory.get();
            schema.put("properties", (Object)properties);
            schema.put("$ref", (Object)("#/definitions/" + type.getSimpleName()));
            JSONObject clone = (JSONObject)schema.clone();
            clone.remove((Object)"$ref");
            Factory.definitions.put(type.getSimpleName(), (Object)clone);
            for (Field declaredField : declaredFields) {
                if (declaredField.isAnnotationPresent(ParamIgnore.class)) continue;
                properties.put(declaredField.getName(), (Object)RequestTypeMatchingSwagger.deepObject(Factory.get(), declaredField));
            }
            list.add(api);
        }
    }

    private static JSONObject deepObject(JSONObject json, Field declaredField) {
        String desc = declaredField.getName();
        if (declaredField.isAnnotationPresent(ParamDesc.class)) {
            ParamDesc annotation = declaredField.getAnnotation(ParamDesc.class);
            desc = annotation.value();
        }
        if (declaredField.getType().isEnum()) {
            json.put("type", (Object)"integer");
            ?[] enumConstants = declaredField.getType().getEnumConstants();
            HashSet<String> jsonArray = new HashSet<String>();
            for (Object enumConstant : enumConstants) {
                jsonArray.add(enumConstant.toString());
            }
            json.put("description", (Object)JSON.toJSONString(jsonArray));
            return json;
        }
        if (declaredField.getType().equals(List.class) || declaredField.getType().equals(Set.class)) {
            Type genericType = declaredField.getGenericType();
            ParameterizedType pt = (ParameterizedType)genericType;
            Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
            json.put("type", (Object)RequestBodyType.ARRAY.type);
            if (RequestTypeMatchingSwagger.checkJavaType(actualTypeArgument.getTypeName())) {
                JSONObject jsonObject = Factory.get();
                jsonObject.put("type", (Object)RequestBodyType.of((String)actualTypeArgument.getSimpleName()).type);
                jsonObject.put("description", (Object)desc);
                json.put("items", (Object)jsonObject);
            } else {
                JSONObject jsonObject = Factory.get();
                jsonObject.put("type", (Object)RequestBodyType.OBJECT.type);
                JSONObject filedObject = Factory.get();
                for (Field field : actualTypeArgument.getDeclaredFields()) {
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    if (field.getType().equals(declaredField.getType())) break;
                    filedObject.put(field.getName(), (Object)RequestTypeMatchingSwagger.deepObject(Factory.get(), field));
                }
                jsonObject.put("properties", (Object)filedObject);
                json.put("items", (Object)jsonObject);
                json.put("description", (Object)desc);
            }
            return json;
        }
        if (RequestTypeMatchingSwagger.checkJavaType(declaredField.getType().getTypeName())) {
            json.put("type", (Object)RequestBodyType.of((String)declaredField.getType().getSimpleName()).type);
            json.put("description", (Object)desc);
            return json;
        }
        Class<?> declaringClass = declaredField.getDeclaringClass();
        json.put("type", (Object)RequestBodyType.OBJECT.type);
        JSONObject objectTypeJSON = Factory.get();
        for (Field field : declaringClass.getDeclaredFields()) {
            objectTypeJSON.put(field.getName(), (Object)RequestTypeMatchingSwagger.deepObject(json, field));
        }
        json.put("properties", (Object)objectTypeJSON);
        json.put("description", (Object)desc);
        return json;
    }

    static boolean checkJavaType(String name) {
        if (name.startsWith("java")) {
            return true;
        }
        switch (name.toLowerCase()) {
            case "int": 
            case "long": 
            case "short": 
            case "double": 
            case "float": 
            case "byte": 
            case "char": 
            case "boolean": {
                return true;
            }
        }
        return false;
    }
}

