/*
 * Decompiled with CFR 0.152.
 */
package com.github.ydoc.swagger;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.ydoc.config.YDocPropertiesConfig;
import com.github.ydoc.config.YapiApi;
import com.github.ydoc.swagger.Factory;
import com.github.ydoc.swagger.RequestTypeMatchingSwagger;
import com.github.ydoc.swagger.Swagger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@EnableConfigurationProperties(value={YDocPropertiesConfig.class})
public class ScanControllerSwagger
implements ApplicationContextAware,
EnvironmentAware,
InitializingBean {
    @Autowired
    YDocPropertiesConfig propertiesConfig;
    private ApplicationContext applicationContext;
    private Environment e;

    public void scan() {
        String json;
        Map restControllerMap = this.applicationContext.getBeansWithAnnotation(RestController.class);
        Swagger swagger = Swagger.initialize();
        swagger.setDefinitions(Factory.definitions);
        swagger.setBasePath(StringUtils.hasText((String)this.e.getProperty("server.servlet.context-path")) ? this.e.getProperty("server.servlet.context-path") : "/");
        ArrayList<Swagger.Tag> tags = new ArrayList<Swagger.Tag>();
        JSONObject paths = new JSONObject();
        for (Map.Entry object : restControllerMap.entrySet()) {
            Method[] methods;
            Class<?> aClass = object.getValue().getClass();
            String outPath = this.buildBaseUrl(aClass);
            if (StringUtils.hasText((String)outPath) && !outPath.startsWith("/") || "/swagger-json".equals(outPath)) continue;
            tags.add(new Swagger.Tag((String)object.getKey(), (String)object.getKey()));
            for (Method method : methods = aClass.getDeclaredMethods()) {
                RequestTypeMatchingSwagger.matching(paths, method, outPath, (String)object.getKey());
            }
        }
        swagger.setPaths(paths);
        swagger.setTags(tags);
        Factory.json = json = JSON.toJSONString((Object)swagger);
        if (this.propertiesConfig.isPrint()) {
            System.out.println(json);
        }
        if (StringUtils.hasText((String)this.propertiesConfig.getHost()) && StringUtils.hasText((String)this.propertiesConfig.getToken())) {
            YapiApi.importDoc(this.propertiesConfig.getToken(), this.propertiesConfig.getHost(), json);
        }
        Factory.definitions.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String buildBaseUrl(Class<?> aClass) {
        RequestMapping annotation;
        String basePath = "";
        if (aClass.isAnnotationPresent(RequestMapping.class) && (annotation = aClass.getAnnotation(RequestMapping.class)).value().length > 0) {
            basePath = annotation.value()[0];
        }
        return basePath;
    }

    public void setEnvironment(Environment environment) {
        this.e = environment;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.propertiesConfig.isEnable()) {
            System.out.println(" >>> YDoc Sync Api start !<<<");
            this.scan();
            System.out.println(" >>> YDoc Sync Api Successful !<<<");
        }
    }
}

