/*
 * Decompiled with CFR 0.152.
 */
package com.github.ydoc.swagger;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.ydoc.config.YDocPropertiesConfig;
import com.github.ydoc.config.YapiApi;
import com.github.ydoc.swagger.Factory;
import com.github.ydoc.swagger.RequestTypeMatchingSwagger;
import com.github.ydoc.swagger.Swagger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@EnableConfigurationProperties(value={YDocPropertiesConfig.class})
public class ScanControllerSwagger
implements ApplicationContextAware,
EnvironmentAware,
InitializingBean,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ScanControllerSwagger.class);
    @Autowired
    YDocPropertiesConfig propertiesConfig;
    @Autowired
    DocumentationCache documentationCache;
    @Autowired
    ServiceModelToSwagger2Mapper map;
    private ApplicationContext applicationContext;
    private Environment e;
    Supplier<String> basePath = () -> StringUtils.hasText((String)this.e.getProperty("server.servlet.context-path")) ? this.e.getProperty("server.servlet.context-path") : "/";

    public void scan() {
        Map restControllerMap = this.applicationContext.getBeansWithAnnotation(RestController.class);
        Swagger swagger = Swagger.initialize();
        swagger.setDefinitions(Factory.definitions);
        swagger.setBasePath(this.basePath.get());
        ArrayList<Swagger.Tag> tags = new ArrayList<Swagger.Tag>();
        JSONObject paths = new JSONObject();
        for (Map.Entry object : restControllerMap.entrySet()) {
            Method[] methods;
            Class<?> aClass = object.getValue().getClass();
            String outPath = this.buildBaseUrl(aClass);
            if (StringUtils.hasText((String)outPath) && !outPath.startsWith("/") || "/swagger-json".equals(outPath)) continue;
            tags.add(new Swagger.Tag((String)object.getKey(), (String)object.getKey()));
            for (Method method : methods = aClass.getDeclaredMethods()) {
                RequestTypeMatchingSwagger.matching(paths, method, outPath, (String)object.getKey());
            }
        }
        swagger.setPaths(paths);
        swagger.setTags(tags);
        Factory.json = JSON.toJSONString((Object)swagger);
        if (this.propertiesConfig.isPrint()) {
            this.print();
        }
        if (this.enableImport()) {
            this.importToYApi();
        }
    }

    public void print() {
        log.info(Factory.json);
    }

    public boolean enableImport() {
        return StringUtils.hasText((String)this.propertiesConfig.getHost()) && StringUtils.hasText((String)this.propertiesConfig.getToken());
    }

    public synchronized void importToYApi() {
        YapiApi.importDoc(this.propertiesConfig.getToken(), this.propertiesConfig.getHost(), Factory.json);
        Factory.definitions.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String buildBaseUrl(Class<?> aClass) {
        RequestMapping annotation;
        String basePath = "";
        if (aClass.isAnnotationPresent(RequestMapping.class) && (annotation = aClass.getAnnotation(RequestMapping.class)).value().length > 0) {
            basePath = annotation.value()[0];
        }
        return basePath;
    }

    public void setEnvironment(Environment environment) {
        this.e = environment;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.propertiesConfig.isEnable()) {
            log.info(" >>> YDoc Sync Api start !<<<");
            if (!this.propertiesConfig.isSwaggerNative() && this.documentationCache != null && this.map != null && this.enableImport()) {
                this.scan();
            }
            log.info(" >>> YDoc Sync Api Successful !<<<");
        }
    }

    public void run(String ... args) throws Exception {
        if (this.propertiesConfig.isSwaggerNative() && this.documentationCache != null && this.map != null && this.enableImport()) {
            log.info(" >>> YDoc Sync Api start !<<<");
            if (this.documentationCache.all().values().size() > 0) {
                Documentation documentation = (Documentation)new ArrayList(this.documentationCache.all().values()).get(0);
                io.swagger.models.Swagger swagger = this.map.mapDocumentation(documentation);
                swagger.setBasePath(this.basePath.get());
                Factory.json = JSON.toJSONString((Object)swagger);
                if (this.propertiesConfig.isPrint()) {
                    this.print();
                }
                this.importToYApi();
            } else {
                log.warn("\u672a\u53d1\u73b0\u4efb\u4f55Api,\u53ef\u80fd\u672a\u914d\u7f6eSwagger2 Config....");
            }
            log.info(" >>> YDoc Sync Api Successful !<<<");
        }
    }
}

