/*
 * Decompiled with CFR 0.152.
 */
package com.github.ydoc.yapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.ydoc.anno.ParamDesc;
import com.github.ydoc.yapi.RequestBodyJson;
import com.github.ydoc.yapi.RequestBodyType;
import com.github.ydoc.yapi.Required;
import com.github.ydoc.yapi.Yapi;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class RequestTypeMatching {
    public static void matching(Method method, Yapi.Api api) {
        if (method.isAnnotationPresent(GetMapping.class)) {
            RequestTypeMatching.get(method, api);
        } else if (method.isAnnotationPresent(PostMapping.class)) {
            RequestTypeMatching.post(method, api);
        } else if (method.isAnnotationPresent(PutMapping.class)) {
            RequestTypeMatching.put(method, api);
        } else if (method.isAnnotationPresent(DeleteMapping.class)) {
            RequestTypeMatching.delete(method, api);
        }
    }

    public static void returnBuild(Method method, Yapi.Api api) {
        Class<?> returnType = method.getReturnType();
        String desc = returnType.getName();
        if (returnType.isAnnotationPresent(ParamDesc.class)) {
            ParamDesc annotation = returnType.getAnnotation(ParamDesc.class);
            desc = annotation.value();
        }
        if (returnType.getName().startsWith("java")) {
            api.setRes_body(JSON.toJSONString((Object)returnType.getName()));
        } else {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)RequestBodyType.OBJECT.type);
            jsonObject.put("title", (Object)"empty object");
            JSONObject data = new JSONObject();
            for (Field declaredField : returnType.getDeclaredFields()) {
                data.put(declaredField.getName(), (Object)RequestTypeMatching.deepObject(new JSONObject(), declaredField));
            }
            jsonObject.put("properties", (Object)data);
            api.setRes_body(JSON.toJSONString((Object)jsonObject));
        }
    }

    private static void get(Method method, Yapi.Api api) {
        api.setReq_headers(null);
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        api.setMethod("GET");
        if (getMapping.value().length > 0) {
            api.setPath(api.getPath() + getMapping.value()[0]);
        }
        api.setTitle(getMapping.name());
        System.out.println("controller\u65b9\u6cd5\u63cf\u8ff0 " + getMapping.name());
        Parameter[] parameters = method.getParameters();
        ArrayList<Yapi.ReqQuery> reqQueries = new ArrayList<Yapi.ReqQuery>();
        for (Parameter parameterType : parameters) {
            Field[] declaredFields;
            Yapi.ReqQuery reqQuery;
            String paramName = "";
            String paramType = parameterType.getType().getSimpleName();
            String paramDesc = parameterType.getName();
            if (parameterType.isAnnotationPresent(RequestParam.class)) {
                reqQuery = new Yapi.ReqQuery();
                RequestParam annotation = parameterType.getAnnotation(RequestParam.class);
                paramName = annotation.value();
                paramDesc = annotation.name();
                reqQuery.setName(paramName);
                reqQuery.setRequired(annotation.required() ? Required.TRUE.getCode() : Required.FALSE.getCode());
                reqQueries.add(reqQuery);
                continue;
            }
            if (parameterType.getParameterizedType().getTypeName().startsWith("java")) {
                reqQuery = new Yapi.ReqQuery();
                reqQuery.setName(parameterType.getName());
                reqQuery.setDesc(parameterType.getName());
                reqQuery.setRequired(Required.FALSE.getCode());
                reqQueries.add(reqQuery);
                System.out.println("\u5bf9\u8c61\u5185\u53c2\u6570\u540d " + reqQuery.getName());
                System.out.println("\u5bf9\u8c61\u5185\u53c2\u6570\u63cf\u8ff0" + reqQuery.getDesc());
                System.out.println("\u5bf9\u8c61\u5185\u53c2\u6570\u662f\u5426\u5fc5\u987b" + reqQuery.getRequired());
                continue;
            }
            for (Field field : declaredFields = parameterType.getType().getDeclaredFields()) {
                Yapi.ReqQuery reqQuery2 = new Yapi.ReqQuery();
                if (field.isAnnotationPresent(ParamDesc.class)) {
                    ParamDesc annotation = field.getAnnotation(ParamDesc.class);
                    reqQuery2.setDesc(annotation.value());
                    reqQuery2.setRequired(annotation.required() ? Required.TRUE.getCode() : Required.FALSE.getCode());
                } else {
                    reqQuery2.setDesc(field.getName());
                    reqQuery2.setRequired(Required.FALSE.getCode());
                }
                reqQuery2.setName(field.getName());
                reqQueries.add(reqQuery2);
                System.out.println("\u5bf9\u8c61\u5185\u53c2\u6570\u540d " + reqQuery2.getName());
                System.out.println("\u5bf9\u8c61\u5185\u53c2\u6570\u63cf\u8ff0" + reqQuery2.getDesc());
                System.out.println("\u5bf9\u8c61\u5185\u53c2\u6570\u662f\u5426\u5fc5\u987b" + reqQuery2.getRequired());
            }
        }
    }

    private static void post(Method method, Yapi.Api api) {
        api.setReq_body_is_json_schema(true);
        api.setRes_body_is_json_schema(true);
        api.setMethod("POST");
        api.setRes_body_type("json");
        api.setReq_headers(Collections.singletonList(new Yapi.Header()));
        PostMapping annotation = method.getAnnotation(PostMapping.class);
        if (annotation.value().length > 0) {
            api.setPath(api.getPath() + annotation.value()[0]);
        }
        api.setTitle(annotation.name());
        RequestTypeMatching.baseRequestBody(method.getParameters(), api);
    }

    private static void delete(Method method, Yapi.Api api) {
        api.setReq_body_is_json_schema(true);
        api.setRes_body_is_json_schema(true);
        api.setMethod("DELETE");
        api.setRes_body_type("json");
        api.setReq_headers(Collections.singletonList(new Yapi.Header()));
        DeleteMapping annotation = method.getAnnotation(DeleteMapping.class);
        if (annotation.value().length > 0) {
            api.setPath(api.getPath() + annotation.value()[0]);
        }
        api.setTitle(annotation.name());
        RequestTypeMatching.baseRequestBody(method.getParameters(), api);
    }

    private static void put(Method method, Yapi.Api api) {
        api.setReq_body_is_json_schema(true);
        api.setRes_body_is_json_schema(true);
        api.setMethod("PUT");
        api.setRes_body_type("json");
        api.setReq_headers(Collections.singletonList(new Yapi.Header()));
        PutMapping annotation = method.getAnnotation(PutMapping.class);
        if (annotation.value().length > 0) {
            api.setPath(api.getPath() + annotation.value()[0]);
        }
        api.setTitle(annotation.name());
        RequestTypeMatching.baseRequestBody(method.getParameters(), api);
    }

    private static void baseRequestBody(Parameter[] parameters, Yapi.Api api) {
        RequestBodyJson requestBodyJson = new RequestBodyJson();
        for (Parameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(RequestBody.class)) continue;
            Class<?> type = parameter.getType();
            Field[] declaredFields = type.getDeclaredFields();
            JSONObject properties = new JSONObject();
            for (Field declaredField : declaredFields) {
                properties.put(declaredField.getName(), (Object)RequestTypeMatching.deepObject(new JSONObject(), declaredField));
            }
            requestBodyJson.setProperties(properties);
            api.setReq_body_other(JSON.toJSONString((Object)requestBodyJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        }
    }

    private static JSONObject deepObject(JSONObject json, Field declaredField) {
        String desc = declaredField.getName();
        if (declaredField.isAnnotationPresent(ParamDesc.class)) {
            ParamDesc annotation = declaredField.getAnnotation(ParamDesc.class);
            desc = annotation.value();
        }
        if (declaredField.getType().isEnum()) {
            json.put("type", (Object)"integer");
            json.put("description", (Object)desc);
            return json;
        }
        if (declaredField.getType().equals(List.class) || declaredField.getType().equals(Set.class)) {
            Type genericType = declaredField.getGenericType();
            ParameterizedType pt = (ParameterizedType)genericType;
            Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
            json.put("type", (Object)RequestBodyType.ARRAY.type);
            if (actualTypeArgument.getTypeName().startsWith("java")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)RequestBodyType.of(actualTypeArgument.getSimpleName()));
                jsonObject.put("description", (Object)desc);
                json.put("items", (Object)jsonObject);
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)RequestBodyType.OBJECT.type);
                JSONObject filedObject = new JSONObject();
                for (Field field : actualTypeArgument.getDeclaredFields()) {
                    if (field.getType().equals(declaredField.getType())) {
                        filedObject.put(field.getName(), (Object)RequestTypeMatching.deepObject(new JSONObject(), field));
                        continue;
                    }
                    filedObject.put(field.getName(), (Object)RequestTypeMatching.deepObject(new JSONObject(), field));
                }
                jsonObject.put("properties", (Object)filedObject);
                json.put("items", (Object)jsonObject);
                json.put("description", (Object)desc);
            }
            return json;
        }
        if (declaredField.getType().getTypeName().startsWith("java")) {
            json.put("type", (Object)RequestBodyType.of(declaredField.getType().getSimpleName()));
            json.put("description", (Object)desc);
            return json;
        }
        Class<?> declaringClass = declaredField.getDeclaringClass();
        json.put("type", (Object)RequestBodyType.OBJECT.type);
        JSONObject objectTypeJSON = new JSONObject();
        for (Field field : declaringClass.getDeclaredFields()) {
            objectTypeJSON.put(field.getName(), (Object)RequestTypeMatching.deepObject(json, field));
        }
        json.put("properties", (Object)objectTypeJSON);
        json.put("description", (Object)desc);
        return json;
    }
}

