/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf;

import com.github.noconnor.junitperf.JUnitPerfReportingConfig;
import com.github.noconnor.junitperf.JUnitPerfTest;
import com.github.noconnor.junitperf.JUnitPerfTestActiveConfig;
import com.github.noconnor.junitperf.JUnitPerfTestRequirement;
import com.github.noconnor.junitperf.TestContextSupplier;
import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.reporting.ReportGenerator;
import com.github.noconnor.junitperf.reporting.providers.ConsoleReportGenerator;
import com.github.noconnor.junitperf.statements.ExceptionsRegistry;
import com.github.noconnor.junitperf.statements.FullStatement;
import com.github.noconnor.junitperf.statements.PerformanceEvaluationStatement;
import com.github.noconnor.junitperf.statements.TestStatement;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.github.noconnor.junitperf.statistics.providers.DescriptiveStatisticsCalculator;
import com.github.noconnor.junitperf.suite.SuiteRegistry;
import com.github.noconnor.junitperf.utils.TestReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitPerfInterceptor
implements InvocationInterceptor,
TestInstancePostProcessor,
ParameterResolver {
    private static final Logger log = LoggerFactory.getLogger(JUnitPerfInterceptor.class);
    protected static final ReportGenerator DEFAULT_REPORTER = new ConsoleReportGenerator();
    protected static final Map<String, TestDetails> testContexts = new ConcurrentHashMap<String, TestDetails>();
    protected static final Map<String, SharedConfig> sharedContexts = new ConcurrentHashMap<String, SharedConfig>();

    public synchronized void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        if (sharedContexts.containsKey(context.getUniqueId())) {
            log.debug("Test already configured");
            return;
        }
        SharedConfig test = new SharedConfig();
        SuiteRegistry.scanForSuiteDetails(context);
        JUnitPerfReportingConfig reportingConfig = JUnitPerfInterceptor.findTestActiveConfigField(testInstance, context);
        if (Objects.nonNull(reportingConfig)) {
            test.setActiveReporters(reportingConfig.getReportGenerators());
            test.setStatsSupplier(reportingConfig.getStatisticsCalculatorSupplier());
        }
        sharedContexts.put(context.getUniqueId(), test);
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptTestMethod(invocation, invocationContext, extensionContext);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Method method = extensionContext.getRequiredTestMethod();
        Object testInstance = extensionContext.getRequiredTestInstance();
        JUnitPerfTest perfTestAnnotation = this.getJUnitPerfTestDetails(method, extensionContext);
        JUnitPerfTestRequirement requirementsAnnotation = this.getJUnitPerfTestRequirementDetails(method, extensionContext);
        if (Objects.nonNull(perfTestAnnotation)) {
            log.trace("Using {} for {} : {}", new Object[]{perfTestAnnotation, JUnitPerfInterceptor.getUniqueId(extensionContext), JUnitPerfInterceptor.getUniqueId(extensionContext.getRoot())});
            EvaluationContext context = this.createEvaluationContext(extensionContext, invocationContext);
            context.loadConfiguration(perfTestAnnotation);
            context.loadRequirements(requirementsAnnotation);
            TestDetails test = JUnitPerfInterceptor.getTestDetails(extensionContext);
            test.setTestClass(method.getDeclaringClass());
            test.setTestMethod(method);
            test.setMeasurementsStartTimeMs(System.currentTimeMillis() + (long)perfTestAnnotation.warmUpMs());
            test.setContext(context);
            FullStatement testStatement = new FullStatement(testInstance, method, invocationContext.getArguments());
            testStatement.setBeforeEach(TestReflectionUtils.findBeforeEach(testInstance));
            testStatement.setAfterEach(TestReflectionUtils.findAfterEach(testInstance));
            PerformanceEvaluationStatement parallelExecution = test.getStatementBuilder().baseStatement((TestStatement)testStatement).statistics(test.getStatsCalculator()).context(context).listener(complete -> this.updateReport(test)).build();
            parallelExecution.runParallelEvaluation();
            invocation.skip();
        } else {
            log.trace("No @JUnitPerfTest annotation for {} : {}", (Object)JUnitPerfInterceptor.getUniqueId(extensionContext), (Object)JUnitPerfInterceptor.getUniqueId(extensionContext.getRoot()));
            invocation.proceed();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == TestContextSupplier.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        TestDetails test = JUnitPerfInterceptor.getTestDetails(extensionContext);
        return new TestContextSupplier(test.getMeasurementsStartTimeMs(), test.getStatsCalculator());
    }

    protected JUnitPerfTestRequirement getJUnitPerfTestRequirementDetails(Method method, ExtensionContext ctxt) {
        JUnitPerfTestRequirement methodAnnotation = method.getAnnotation(JUnitPerfTestRequirement.class);
        JUnitPerfTestRequirement classAnnotation = method.getDeclaringClass().getAnnotation(JUnitPerfTestRequirement.class);
        JUnitPerfTestRequirement suiteAnnotation = SuiteRegistry.getPerfRequirements(ctxt);
        JUnitPerfTestRequirement specifiedAnnotation = Objects.nonNull(methodAnnotation) ? methodAnnotation : classAnnotation;
        return Objects.nonNull(specifiedAnnotation) ? specifiedAnnotation : suiteAnnotation;
    }

    protected JUnitPerfTest getJUnitPerfTestDetails(Method method, ExtensionContext ctxt) {
        JUnitPerfTest methodAnnotation = method.getAnnotation(JUnitPerfTest.class);
        JUnitPerfTest classAnnotation = method.getDeclaringClass().getAnnotation(JUnitPerfTest.class);
        JUnitPerfTest suiteAnnotation = SuiteRegistry.getPerfTestData(ctxt);
        JUnitPerfTest specifiedAnnotation = Objects.nonNull(methodAnnotation) ? methodAnnotation : classAnnotation;
        return Objects.nonNull(specifiedAnnotation) ? specifiedAnnotation : suiteAnnotation;
    }

    protected EvaluationContext createEvaluationContext(ExtensionContext extensionContext, ReflectiveInvocationContext<Method> invocationContext) {
        String testName = extensionContext.getDisplayName();
        String groupName = ((Method)invocationContext.getExecutable()).getDeclaringClass().getName();
        boolean isAsync = invocationContext.getArguments().stream().anyMatch(arg -> arg instanceof TestContextSupplier);
        EvaluationContext ctx = new EvaluationContext(testName, System.nanoTime(), isAsync);
        ctx.setGroupName(groupName);
        return ctx;
    }

    private synchronized void updateReport(TestDetails test) {
        test.getActiveReporters().forEach(r -> {
            LinkedHashSet<EvaluationContext> ctxt = new LinkedHashSet<EvaluationContext>();
            ctxt.add(test.getContext());
            r.generateReport(ctxt);
        });
    }

    private static void failIfNonStatic(Field field) {
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (!isStatic) {
            throw new IllegalStateException("JUnitPerfTestConfig should be static ");
        }
    }

    private static JUnitPerfReportingConfig findTestActiveConfigField(Object testInstance, ExtensionContext ctxt) throws IllegalAccessException {
        Class<?> testClass = testInstance.getClass();
        JUnitPerfReportingConfig config = JUnitPerfInterceptor.scanForReportingConfig(testInstance, testClass);
        return Objects.isNull(config) ? SuiteRegistry.getReportingConfig(ctxt) : config;
    }

    private static JUnitPerfReportingConfig scanForReportingConfig(Object testInstance, Class<?> testClass) throws IllegalAccessException {
        if (Objects.isNull(testClass)) {
            return null;
        }
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(JUnitPerfTestActiveConfig.class)) continue;
            JUnitPerfInterceptor.failIfNonStatic(field);
            field.setAccessible(true);
            return (JUnitPerfReportingConfig)field.get(testInstance);
        }
        return JUnitPerfInterceptor.scanForReportingConfig(testInstance, testClass.getSuperclass());
    }

    private static String getUniqueId(ExtensionContext extensionContext) {
        return Objects.nonNull(extensionContext) ? extensionContext.getUniqueId() : "(no root)";
    }

    private static TestDetails getTestDetails(ExtensionContext extensionContext) {
        String testId = extensionContext.getUniqueId();
        testContexts.computeIfAbsent(testId, newTestId -> {
            SharedConfig sharedDetails = JUnitPerfInterceptor.getParentSharedContext(extensionContext);
            TestDetails testDetails = new TestDetails();
            testDetails.setStatementBuilder(sharedDetails.getStatementBuilder().get());
            testDetails.setActiveReporters(sharedDetails.getActiveReporters());
            testDetails.setStatsCalculator(sharedDetails.getStatsSupplier().get());
            return testDetails;
        });
        return testContexts.get(testId);
    }

    private static SharedConfig getParentSharedContext(ExtensionContext extensionContext) {
        Optional parentContext = extensionContext.getParent();
        Optional<SharedConfig> sharedDetails = parentContext.map(ExtensionContext::getUniqueId).map(sharedContexts::get);
        if (sharedDetails.isPresent()) {
            return sharedDetails.get();
        }
        if (parentContext.isPresent()) {
            return JUnitPerfInterceptor.getParentSharedContext((ExtensionContext)parentContext.get());
        }
        return new SharedConfig();
    }

    static {
        ExceptionsRegistry.registerIgnorable(InterruptedException.class);
        ExceptionsRegistry.registerAbort(TestAbortedException.class);
    }

    protected static class SharedConfig {
        private Collection<ReportGenerator> activeReporters = Collections.singletonList(DEFAULT_REPORTER);
        private Supplier<StatisticsCalculator> statsSupplier = DescriptiveStatisticsCalculator::new;
        private Supplier<PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder> statementBuilder = PerformanceEvaluationStatement::builder;

        public Collection<ReportGenerator> getActiveReporters() {
            return this.activeReporters;
        }

        public Supplier<StatisticsCalculator> getStatsSupplier() {
            return this.statsSupplier;
        }

        public Supplier<PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder> getStatementBuilder() {
            return this.statementBuilder;
        }

        public void setActiveReporters(Collection<ReportGenerator> activeReporters) {
            this.activeReporters = activeReporters;
        }

        public void setStatsSupplier(Supplier<StatisticsCalculator> statsSupplier) {
            this.statsSupplier = statsSupplier;
        }

        public void setStatementBuilder(Supplier<PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder> statementBuilder) {
            this.statementBuilder = statementBuilder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SharedConfig)) {
                return false;
            }
            SharedConfig other = (SharedConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<ReportGenerator> this$activeReporters = this.getActiveReporters();
            Collection<ReportGenerator> other$activeReporters = other.getActiveReporters();
            if (this$activeReporters == null ? other$activeReporters != null : !((Object)this$activeReporters).equals(other$activeReporters)) {
                return false;
            }
            Supplier<StatisticsCalculator> this$statsSupplier = this.getStatsSupplier();
            Supplier<StatisticsCalculator> other$statsSupplier = other.getStatsSupplier();
            if (this$statsSupplier == null ? other$statsSupplier != null : !this$statsSupplier.equals(other$statsSupplier)) {
                return false;
            }
            Supplier<PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder> this$statementBuilder = this.getStatementBuilder();
            Supplier<PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder> other$statementBuilder = other.getStatementBuilder();
            return !(this$statementBuilder == null ? other$statementBuilder != null : !this$statementBuilder.equals(other$statementBuilder));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SharedConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<ReportGenerator> $activeReporters = this.getActiveReporters();
            result = result * 59 + ($activeReporters == null ? 43 : ((Object)$activeReporters).hashCode());
            Supplier<StatisticsCalculator> $statsSupplier = this.getStatsSupplier();
            result = result * 59 + ($statsSupplier == null ? 43 : $statsSupplier.hashCode());
            Supplier<PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder> $statementBuilder = this.getStatementBuilder();
            result = result * 59 + ($statementBuilder == null ? 43 : $statementBuilder.hashCode());
            return result;
        }

        public String toString() {
            return "JUnitPerfInterceptor.SharedConfig(activeReporters=" + this.getActiveReporters() + ", statsSupplier=" + this.getStatsSupplier() + ", statementBuilder=" + this.getStatementBuilder() + ")";
        }
    }

    protected static class TestDetails {
        private Class<?> testClass;
        private Method testMethod;
        private long measurementsStartTimeMs;
        private EvaluationContext context;
        private StatisticsCalculator statsCalculator;
        private Collection<ReportGenerator> activeReporters;
        private PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder statementBuilder;

        public Class<?> getTestClass() {
            return this.testClass;
        }

        public Method getTestMethod() {
            return this.testMethod;
        }

        public long getMeasurementsStartTimeMs() {
            return this.measurementsStartTimeMs;
        }

        public EvaluationContext getContext() {
            return this.context;
        }

        public StatisticsCalculator getStatsCalculator() {
            return this.statsCalculator;
        }

        public Collection<ReportGenerator> getActiveReporters() {
            return this.activeReporters;
        }

        public PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder getStatementBuilder() {
            return this.statementBuilder;
        }

        public void setTestClass(Class<?> testClass) {
            this.testClass = testClass;
        }

        public void setTestMethod(Method testMethod) {
            this.testMethod = testMethod;
        }

        public void setMeasurementsStartTimeMs(long measurementsStartTimeMs) {
            this.measurementsStartTimeMs = measurementsStartTimeMs;
        }

        public void setContext(EvaluationContext context) {
            this.context = context;
        }

        public void setStatsCalculator(StatisticsCalculator statsCalculator) {
            this.statsCalculator = statsCalculator;
        }

        public void setActiveReporters(Collection<ReportGenerator> activeReporters) {
            this.activeReporters = activeReporters;
        }

        public void setStatementBuilder(PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder statementBuilder) {
            this.statementBuilder = statementBuilder;
        }

        public String toString() {
            return "JUnitPerfInterceptor.TestDetails(testClass=" + this.getTestClass() + ", testMethod=" + this.getTestMethod() + ", measurementsStartTimeMs=" + this.getMeasurementsStartTimeMs() + ", context=" + this.getContext() + ", statsCalculator=" + this.getStatsCalculator() + ", activeReporters=" + this.getActiveReporters() + ", statementBuilder=" + this.getStatementBuilder() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestDetails)) {
                return false;
            }
            TestDetails other = (TestDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$testClass = this.getTestClass();
            Class<?> other$testClass = other.getTestClass();
            if (this$testClass == null ? other$testClass != null : !this$testClass.equals(other$testClass)) {
                return false;
            }
            Method this$testMethod = this.getTestMethod();
            Method other$testMethod = other.getTestMethod();
            return !(this$testMethod == null ? other$testMethod != null : !((Object)this$testMethod).equals(other$testMethod));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TestDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $testClass = this.getTestClass();
            result = result * 59 + ($testClass == null ? 43 : $testClass.hashCode());
            Method $testMethod = this.getTestMethod();
            result = result * 59 + ($testMethod == null ? 43 : ((Object)$testMethod).hashCode());
            return result;
        }
    }
}

