/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf;

import com.github.noconnor.junitperf.JUnitPerfTest;
import com.github.noconnor.junitperf.JUnitPerfTestRequirement;
import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.reporting.ReportGenerator;
import com.github.noconnor.junitperf.reporting.providers.HtmlReportGenerator;
import com.github.noconnor.junitperf.statements.PerformanceEvaluationStatement;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.github.noconnor.junitperf.statistics.providers.DescriptiveStatisticsCalculator;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitPerfRule
implements TestRule {
    private static final Logger log = LoggerFactory.getLogger(JUnitPerfRule.class);
    static final Map<Class, Set<EvaluationContext>> ACTIVE_CONTEXTS = Maps.newHashMap();
    private final StatisticsCalculator statisticsCalculator;
    private final Set<ReportGenerator> reporters;
    PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder perEvalBuilder = PerformanceEvaluationStatement.builder();

    public JUnitPerfRule() {
        this(new DescriptiveStatisticsCalculator(), new HtmlReportGenerator());
    }

    public JUnitPerfRule(ReportGenerator ... reportGenerator) {
        this(new DescriptiveStatisticsCalculator(), reportGenerator);
    }

    public JUnitPerfRule(StatisticsCalculator statisticsCalculator) {
        this(statisticsCalculator, new HtmlReportGenerator());
    }

    public JUnitPerfRule(StatisticsCalculator statisticsCalculator, ReportGenerator ... reportGenerator) {
        this.statisticsCalculator = statisticsCalculator;
        this.reporters = Sets.newHashSet((Object[])reportGenerator);
    }

    public Statement apply(Statement base, Description description) {
        Statement activeStatement = base;
        JUnitPerfTest perfTestAnnotation = (JUnitPerfTest)description.getAnnotation(JUnitPerfTest.class);
        JUnitPerfTestRequirement requirementsAnnotation = (JUnitPerfTestRequirement)description.getAnnotation(JUnitPerfTestRequirement.class);
        if (Objects.nonNull(perfTestAnnotation)) {
            ACTIVE_CONTEXTS.putIfAbsent(description.getTestClass(), Sets.newHashSet());
            EvaluationContext context = new EvaluationContext(description.getMethodName(), this.generateTestStartTime());
            context.loadConfiguration(perfTestAnnotation);
            context.loadRequirements(requirementsAnnotation);
            ACTIVE_CONTEXTS.get(description.getTestClass()).add(context);
            activeStatement = this.perEvalBuilder.baseStatement(base).statistics(this.statisticsCalculator).context(context).listener(complete -> this.updateReport(description.getTestClass())).build();
        }
        return activeStatement;
    }

    private synchronized void updateReport(Class<?> testClass) {
        this.reporters.forEach(r -> r.generateReport(ACTIVE_CONTEXTS.get(testClass)));
    }

    private String generateTestStartTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
}

