/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.data;

import com.github.noconnor.junitperf.JUnitPerfTest;
import com.github.noconnor.junitperf.JUnitPerfTestRequirement;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class EvaluationContext {
    private int configuredThreads;
    private int configuredDuration;
    private int configuredWarmUp;
    private int configuredRateLimit;
    private Map<Integer, Float> requiredPercentiles = Collections.emptyMap();
    private int requiredThroughput = 0;
    private float requiredAllowedErrorsRate = 0.0f;
    private float requiredMinLatency = -1.0f;
    private float requiredMaxLatency = -1.0f;
    private float requiredMeanLatency = -1.0f;
    private StatisticsCalculator statistics;
    private boolean isThroughputAchieved;
    private boolean isMinLatencyAchieved;
    private boolean isMaxLatencyAchieved;
    private boolean isMeanLatencyAchieved;
    private boolean isErrorThresholdAchieved;
    private Map<Integer, Boolean> percentileResults;
    private boolean isSuccessful;
    private float[] percentiles = new float[101];
    private float minLatencyMs;
    private float maxLatencyMs;
    private float meanLatencyMs;
    private float errorPercentage;
    private long evaluationCount;
    private long errorCount;
    private final String testName;
    private final String startTime;

    public long getThroughputQps() {
        return (long)((float)this.evaluationCount / ((float)this.configuredDuration - (float)this.configuredWarmUp) * 1000.0f);
    }

    public float getLatencyPercentileMs(int percentile) {
        return this.percentiles[percentile];
    }

    public void loadConfiguration(JUnitPerfTest testSettings) {
        this.validateTestSettings(testSettings);
        this.configuredThreads = testSettings.threads();
        this.configuredDuration = testSettings.durationMs();
        this.configuredWarmUp = testSettings.warmUpMs();
        this.configuredRateLimit = testSettings.maxExecutionsPerSecond();
    }

    public void loadRequirements(JUnitPerfTestRequirement requirements) {
        if (Objects.nonNull(requirements)) {
            this.validateRequirements(requirements);
            this.requiredThroughput = requirements.executionsPerSec();
            this.requiredAllowedErrorsRate = requirements.allowedErrorPercentage();
            this.requiredPercentiles = EvaluationContext.parsePercentileLimits(requirements.percentiles());
            this.requiredMinLatency = requirements.minLatency();
            this.requiredMaxLatency = requirements.maxLatency();
            this.requiredMeanLatency = requirements.meanLatency();
        }
    }

    public void runValidation() {
        Preconditions.checkState((boolean)Objects.nonNull(this.statistics), (Object)"Statistics must be calculated before running validation");
        this.calculateAndCacheStatistics();
        this.isThroughputAchieved = this.getThroughputQps() >= (long)this.requiredThroughput;
        this.isErrorThresholdAchieved = this.errorPercentage <= this.requiredAllowedErrorsRate * 100.0f;
        this.isMinLatencyAchieved = this.validateLatency(this.minLatencyMs, this.requiredMinLatency);
        this.isMaxLatencyAchieved = this.validateLatency(this.maxLatencyMs, this.requiredMaxLatency);
        this.isMeanLatencyAchieved = this.validateLatency(this.meanLatencyMs, this.requiredMeanLatency);
        this.percentileResults = this.evaluateLatencyPercentiles();
        this.isSuccessful = this.isThroughputAchieved && this.isMaxLatencyAchieved && this.isMinLatencyAchieved && this.isMeanLatencyAchieved && this.isErrorThresholdAchieved && this.noLatencyPercentileFailures();
    }

    private boolean validateLatency(float actualMs, float requiredMs) {
        return requiredMs < 0.0f || actualMs <= requiredMs;
    }

    private boolean noLatencyPercentileFailures() {
        return this.percentileResults.values().stream().allMatch(e -> e);
    }

    private Map<Integer, Boolean> evaluateLatencyPercentiles() {
        TreeMap results = Maps.newTreeMap();
        this.requiredPercentiles.forEach((percentile, thresholdMs) -> {
            boolean result = this.getLatencyPercentileMs((int)percentile) <= thresholdMs.floatValue();
            results.put(percentile, result);
        });
        return results;
    }

    private static Map<Integer, Float> parsePercentileLimits(String percentileLimits) {
        TreeMap limits = Maps.newTreeMap();
        if (StringUtils.isNotBlank((CharSequence)percentileLimits)) {
            Stream.of(percentileLimits.split(",")).map(entry -> entry.split(":")).filter(entry -> ((String[])entry).length == 2).map(entry -> ImmutablePair.of((Object)Ints.tryParse((String)entry[0]), (Object)Floats.tryParse((String)entry[1]))).filter(entry -> Objects.nonNull(entry.getLeft()) && Objects.nonNull(entry.getRight())).forEach(entry -> {
                Float cfr_ignored_0 = (Float)limits.put(entry.getLeft(), entry.getRight());
            });
        }
        return limits;
    }

    private void validateTestSettings(JUnitPerfTest testSettings) {
        Preconditions.checkNotNull((Object)testSettings, (Object)"Test settings must not be null");
        Preconditions.checkState((testSettings.durationMs() > 0 ? 1 : 0) != 0, (Object)"DurationMs must be greater than 0ms");
        Preconditions.checkState((testSettings.warmUpMs() >= 0 ? 1 : 0) != 0, (Object)"WarmUpMs must be >= 0ms");
        Preconditions.checkState((testSettings.warmUpMs() < testSettings.durationMs() ? 1 : 0) != 0, (Object)"WarmUpMs must be < DurationMs");
        Preconditions.checkState((testSettings.threads() > 0 ? 1 : 0) != 0, (Object)"Threads must be > 0");
        Preconditions.checkState((testSettings.maxExecutionsPerSecond() > 0 || testSettings.maxExecutionsPerSecond() == -1 ? 1 : 0) != 0, (Object)"MaxExecutionsPerSecond must be > 0 or -1 (to disable)");
    }

    private void validateRequirements(JUnitPerfTestRequirement requirements) {
        Preconditions.checkState((requirements.allowedErrorPercentage() >= 0.0f ? 1 : 0) != 0, (Object)"AllowedErrorPercentage must be >= 0");
        Preconditions.checkState((requirements.executionsPerSec() >= 0 ? 1 : 0) != 0, (Object)"ExecutionsPerSec must be >= 0");
    }

    private void calculateAndCacheStatistics() {
        IntStream.range(1, 101).forEach(i -> {
            this.percentiles[i] = this.statistics.getLatencyPercentile(i, TimeUnit.MILLISECONDS);
        });
        this.minLatencyMs = this.statistics.getMinLatency(TimeUnit.MILLISECONDS);
        this.maxLatencyMs = this.statistics.getMaxLatency(TimeUnit.MILLISECONDS);
        this.meanLatencyMs = this.statistics.getMeanLatency(TimeUnit.MILLISECONDS);
        this.errorPercentage = this.statistics.getErrorPercentage();
        this.errorCount = this.statistics.getErrorCount();
        this.evaluationCount = this.statistics.getEvaluationCount();
    }

    @ConstructorProperties(value={"testName", "startTime"})
    public EvaluationContext(String testName, String startTime) {
        this.testName = testName;
        this.startTime = startTime;
    }

    public int getConfiguredThreads() {
        return this.configuredThreads;
    }

    public int getConfiguredDuration() {
        return this.configuredDuration;
    }

    public int getConfiguredWarmUp() {
        return this.configuredWarmUp;
    }

    public int getConfiguredRateLimit() {
        return this.configuredRateLimit;
    }

    public Map<Integer, Float> getRequiredPercentiles() {
        return this.requiredPercentiles;
    }

    public int getRequiredThroughput() {
        return this.requiredThroughput;
    }

    public float getRequiredAllowedErrorsRate() {
        return this.requiredAllowedErrorsRate;
    }

    public float getRequiredMinLatency() {
        return this.requiredMinLatency;
    }

    public float getRequiredMaxLatency() {
        return this.requiredMaxLatency;
    }

    public float getRequiredMeanLatency() {
        return this.requiredMeanLatency;
    }

    public void setStatistics(StatisticsCalculator statistics) {
        this.statistics = statistics;
    }

    public boolean isThroughputAchieved() {
        return this.isThroughputAchieved;
    }

    public boolean isMinLatencyAchieved() {
        return this.isMinLatencyAchieved;
    }

    public boolean isMaxLatencyAchieved() {
        return this.isMaxLatencyAchieved;
    }

    public boolean isMeanLatencyAchieved() {
        return this.isMeanLatencyAchieved;
    }

    public boolean isErrorThresholdAchieved() {
        return this.isErrorThresholdAchieved;
    }

    public Map<Integer, Boolean> getPercentileResults() {
        return this.percentileResults;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public float[] getPercentiles() {
        return this.percentiles;
    }

    public float getMinLatencyMs() {
        return this.minLatencyMs;
    }

    public float getMaxLatencyMs() {
        return this.maxLatencyMs;
    }

    public float getMeanLatencyMs() {
        return this.meanLatencyMs;
    }

    public float getErrorPercentage() {
        return this.errorPercentage;
    }

    public long getEvaluationCount() {
        return this.evaluationCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getStartTime() {
        return this.startTime;
    }
}

