/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.reporting.providers;

import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.reporting.ReportGenerator;
import com.google.common.base.Joiner;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReportGenerator
implements ReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(CsvReportGenerator.class);
    private static final String DEFAULT_REPORT_PATH = System.getProperty("user.dir") + "/build/reports/junitperf_report.csv";
    private final String reportPath;

    public CsvReportGenerator() {
        this(DEFAULT_REPORT_PATH);
    }

    public CsvReportGenerator(String reportPath) {
        this.reportPath = reportPath;
    }

    @Override
    public void generateReport(Set<EvaluationContext> testContexts) {
        try (BufferedWriter writer = this.newBufferedWriter();){
            writer.write(this.buildHeader());
            writer.newLine();
            testContexts.forEach(context -> {
                String record = String.format("%s,%d,%d,%d,%.4f,%.4f,%.4f,%s", context.getTestName(), context.getConfiguredDuration(), context.getConfiguredThreads(), context.getThroughputQps(), Float.valueOf(context.getMinLatencyMs()), Float.valueOf(context.getMaxLatencyMs()), Float.valueOf(context.getMeanLatencyMs()), Joiner.on((String)",").skipNulls().join(this.generateFormattedPercentileData((EvaluationContext)context)));
                try {
                    writer.write(record);
                    writer.newLine();
                }
                catch (IOException e) {
                    log.error("Unable to write record {}", (Object)record);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getReportPath() {
        return this.reportPath;
    }

    private List<String> generateFormattedPercentileData(EvaluationContext context) {
        return IntStream.range(1, 101).mapToObj(i -> String.format("%.4f", Float.valueOf(context.getLatencyPercentileMs(i)))).collect(Collectors.toList());
    }

    private BufferedWriter newBufferedWriter() throws UnsupportedEncodingException, FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportPath), "utf-8"));
    }

    private String buildHeader() {
        String header = "testName,duration,threadCount,throughput,minLatencyNs,maxLatencyNs,meanLatencyNs,<PERCENTILES>";
        List percentiles = IntStream.range(1, 101).mapToObj(CsvReportGenerator::ordinal).collect(Collectors.toList());
        header = header.replace("<PERCENTILES>", Joiner.on((String)",").join(percentiles));
        return header;
    }

    private static String ordinal(int i) {
        int mod100 = i % 100;
        int mod10 = i % 10;
        if (mod10 == 1 && mod100 != 11) {
            return i + "st";
        }
        if (mod10 == 2 && mod100 != 12) {
            return i + "nd";
        }
        if (mod10 == 3 && mod100 != 13) {
            return i + "rd";
        }
        return i + "th";
    }
}

