/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.reporting.providers;

import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.reporting.ReportGenerator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReportGenerator
implements ReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(HtmlReportGenerator.class);
    private static final String DEFAULT_REPORT_PATH = System.getProperty("user.dir") + "/build/reports/junitperf_report.html";
    private static final String REPORT_TEMPLATE = "templates/report.twig";
    private final String reportPath;

    public HtmlReportGenerator() {
        this(DEFAULT_REPORT_PATH);
    }

    public HtmlReportGenerator(String reportPath) {
        this.reportPath = reportPath;
    }

    @Override
    public void generateReport(Set<EvaluationContext> testContexts) {
        Path outputPath = Paths.get(this.reportPath, new String[0]);
        JtwigTemplate template = JtwigTemplate.classpathTemplate((String)REPORT_TEMPLATE);
        JtwigModel model = JtwigModel.newModel().with("contextData", testContexts);
        try {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            log.info("Rendering report to: " + outputPath);
            template.render(model, Files.newOutputStream(outputPath, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getReportPath() {
        return this.reportPath;
    }
}

