/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.statements;

import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.statements.EvaluationTask;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.runners.model.Statement;

public class PerformanceEvaluationStatement
extends Statement {
    private static final String THREAD_NAME_PATTERN = "perf-eval-thread-%d";
    private static final ThreadFactory FACTORY = new ThreadFactoryBuilder().setNameFormat("perf-eval-thread-%d").build();
    private final EvaluationContext context;
    private final ThreadFactory threadFactory;
    private final Statement baseStatement;
    private final StatisticsCalculator statistics;
    private final Consumer<Void> listener;
    private RateLimiter rateLimiter;

    private PerformanceEvaluationStatement(Statement baseStatement, StatisticsCalculator statistics, EvaluationContext context, ThreadFactory threadFactory, Consumer<Void> listener) {
        this.context = context;
        this.baseStatement = baseStatement;
        this.statistics = statistics;
        this.threadFactory = Objects.nonNull(threadFactory) ? threadFactory : FACTORY;
        this.rateLimiter = context.getConfiguredRateLimit() > 0 ? RateLimiter.create((double)context.getConfiguredRateLimit()) : null;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        ArrayList threads = Lists.newArrayList();
        try {
            for (int i = 0; i < this.context.getConfiguredThreads(); ++i) {
                EvaluationTask task = new EvaluationTask(this.baseStatement, this.rateLimiter, this.statistics, this.context.getConfiguredWarmUp());
                Thread t = this.threadFactory.newThread(task);
                threads.add(t);
                t.start();
            }
            Thread.sleep(this.context.getConfiguredDuration());
        }
        finally {
            threads.forEach(Thread::interrupt);
        }
        this.context.setStatistics(this.statistics);
        this.context.runValidation();
        this.listener.accept(null);
        this.assertThresholdsMet();
    }

    private void assertThresholdsMet() {
        Assert.assertThat((String)"Error threshold not achieved", (Object)this.context.isErrorThresholdAchieved(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Test throughput threshold not achieved", (Object)this.context.isThroughputAchieved(), (Matcher)CoreMatchers.is((Object)true));
        this.context.getPercentileResults().forEach((percentile, isAchieved) -> Assert.assertThat((String)String.format("%dth Percentile has not achieved required threshold", percentile), (Object)isAchieved, (Matcher)CoreMatchers.is((Object)true)));
    }

    public static PerformanceEvaluationStatementBuilder builder() {
        return new PerformanceEvaluationStatementBuilder();
    }

    public static class PerformanceEvaluationStatementBuilder {
        private Statement baseStatement;
        private StatisticsCalculator statistics;
        private EvaluationContext context;
        private ThreadFactory threadFactory;
        private Consumer<Void> listener;

        PerformanceEvaluationStatementBuilder() {
        }

        public PerformanceEvaluationStatementBuilder baseStatement(Statement baseStatement) {
            this.baseStatement = baseStatement;
            return this;
        }

        public PerformanceEvaluationStatementBuilder statistics(StatisticsCalculator statistics) {
            this.statistics = statistics;
            return this;
        }

        public PerformanceEvaluationStatementBuilder context(EvaluationContext context) {
            this.context = context;
            return this;
        }

        public PerformanceEvaluationStatementBuilder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public PerformanceEvaluationStatementBuilder listener(Consumer<Void> listener) {
            this.listener = listener;
            return this;
        }

        public PerformanceEvaluationStatement build() {
            return new PerformanceEvaluationStatement(this.baseStatement, this.statistics, this.context, this.threadFactory, this.listener);
        }

        public String toString() {
            return "PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder(baseStatement=" + this.baseStatement + ", statistics=" + this.statistics + ", context=" + this.context + ", threadFactory=" + this.threadFactory + ", listener=" + this.listener + ")";
        }
    }
}

