/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf;

import com.github.noconnor.junitperf.JUnitPerfRule;
import com.github.noconnor.junitperf.JUnitPerfTest;
import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.data.NoOpTestContext;
import com.github.noconnor.junitperf.data.TestContext;
import com.github.noconnor.junitperf.reporting.ReportGenerator;
import com.github.noconnor.junitperf.reporting.providers.HtmlReportGenerator;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.github.noconnor.junitperf.statistics.providers.DescriptiveStatisticsCalculator;
import java.util.Objects;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JUnitPerfAsyncRule
extends JUnitPerfRule {
    private long measurementsStartTimeMs;

    public JUnitPerfAsyncRule() {
        this(new DescriptiveStatisticsCalculator(), new HtmlReportGenerator());
    }

    public JUnitPerfAsyncRule(ReportGenerator ... reportGenerator) {
        this(new DescriptiveStatisticsCalculator(), reportGenerator);
    }

    public JUnitPerfAsyncRule(StatisticsCalculator statisticsCalculator) {
        this(statisticsCalculator, new HtmlReportGenerator());
    }

    public JUnitPerfAsyncRule(StatisticsCalculator statisticsCalculator, ReportGenerator ... reportGenerator) {
        super(statisticsCalculator, reportGenerator);
    }

    public TestContext newContext() {
        return this.hasMeasurementPeriodStarted() ? new TestContext(this.statisticsCalculator) : NoOpTestContext.INSTANCE;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        this.setMeasurementsStartTime((JUnitPerfTest)description.getAnnotation(JUnitPerfTest.class));
        return super.apply(base, description);
    }

    @Override
    EvaluationContext createEvaluationContext(Description description) {
        return new EvaluationContext(description.getMethodName(), System.nanoTime(), true);
    }

    private void setMeasurementsStartTime(JUnitPerfTest perfTestAnnotation) {
        if (Objects.nonNull(perfTestAnnotation)) {
            this.measurementsStartTimeMs = System.currentTimeMillis() + (long)perfTestAnnotation.warmUpMs();
        }
    }

    private boolean hasMeasurementPeriodStarted() {
        return System.currentTimeMillis() >= this.measurementsStartTimeMs;
    }
}

