/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf;

import com.github.noconnor.junitperf.JUnitPerfTest;
import com.github.noconnor.junitperf.JUnitPerfTestRequirement;
import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.reporting.ReportGenerator;
import com.github.noconnor.junitperf.reporting.providers.HtmlReportGenerator;
import com.github.noconnor.junitperf.statements.PerformanceEvaluationStatement;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.github.noconnor.junitperf.statistics.providers.DescriptiveStatisticsCalculator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JUnitPerfRule
implements TestRule {
    static final Map<Class<?>, LinkedHashSet<EvaluationContext>> ACTIVE_CONTEXTS = new HashMap();
    private final Set<ReportGenerator> reporters;
    StatisticsCalculator statisticsCalculator;
    PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder perEvalBuilder = PerformanceEvaluationStatement.builder();

    public JUnitPerfRule() {
        this(new DescriptiveStatisticsCalculator(), new HtmlReportGenerator());
    }

    public JUnitPerfRule(ReportGenerator ... reportGenerator) {
        this(new DescriptiveStatisticsCalculator(), reportGenerator);
    }

    public JUnitPerfRule(StatisticsCalculator statisticsCalculator) {
        this(statisticsCalculator, new HtmlReportGenerator());
    }

    public JUnitPerfRule(StatisticsCalculator statisticsCalculator, ReportGenerator ... reportGenerator) {
        this.statisticsCalculator = statisticsCalculator;
        this.reporters = Arrays.stream(reportGenerator).collect(Collectors.toSet());
    }

    public Statement apply(Statement base, Description description) {
        Statement activeStatement = base;
        JUnitPerfTest perfTestAnnotation = (JUnitPerfTest)description.getAnnotation(JUnitPerfTest.class);
        JUnitPerfTestRequirement requirementsAnnotation = (JUnitPerfTestRequirement)description.getAnnotation(JUnitPerfTestRequirement.class);
        if (Objects.nonNull(perfTestAnnotation)) {
            EvaluationContext context = this.createEvaluationContext(description);
            context.loadConfiguration(perfTestAnnotation);
            context.loadRequirements(requirementsAnnotation);
            ACTIVE_CONTEXTS.putIfAbsent(description.getTestClass(), new LinkedHashSet());
            ACTIVE_CONTEXTS.get(description.getTestClass()).add(context);
            final PerformanceEvaluationStatement test = this.perEvalBuilder.baseStatement(() -> base.evaluate()).statistics(this.statisticsCalculator).context(context).listener(complete -> this.updateReport(description.getTestClass())).build();
            activeStatement = new Statement(){

                public void evaluate() throws Throwable {
                    test.evaluate();
                }
            };
        }
        return activeStatement;
    }

    EvaluationContext createEvaluationContext(Description description) {
        return new EvaluationContext(description.getMethodName(), System.nanoTime());
    }

    private synchronized void updateReport(Class<?> testClass) {
        this.reporters.forEach(r -> r.generateReport(ACTIVE_CONTEXTS.get(testClass)));
    }
}

