/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.reporting.providers;

import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.reporting.ReportGenerator;
import com.github.noconnor.junitperf.reporting.utils.FormatterUtils;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleReportGenerator
implements ReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(ConsoleReportGenerator.class);
    private static final String PASSED = "PASSED";
    private static final String FAILED = "FAILED!!";

    @Override
    public void generateReport(LinkedHashSet<EvaluationContext> testContexts) {
        Iterator itr = testContexts.iterator();
        EvaluationContext context = (EvaluationContext)itr.next();
        while (itr.hasNext()) {
            context = (EvaluationContext)itr.next();
        }
        this.updateReport(context);
    }

    public void updateReport(EvaluationContext context) {
        String throughputStatus = context.isThroughputAchieved() ? PASSED : FAILED;
        String errorRateStatus = context.isErrorThresholdAchieved() ? PASSED : FAILED;
        log.info("Test Name:    {}", (Object)context.getTestName());
        log.info("Started at:   {}", (Object)context.getStartTime());
        log.info("Invocations:  {}", (Object)context.getEvaluationCount());
        log.info("  - Success:  {}", (Object)(context.getEvaluationCount() - context.getErrorCount()));
        log.info("  - Errors:   {}", (Object)context.getErrorCount());
        log.info("  - Errors:   {}% - {}", (Object)Float.valueOf(context.getErrorPercentage()), (Object)errorRateStatus);
        log.info("");
        log.info("Thread Count: {}", (Object)context.getConfiguredThreads());
        log.info("Warm up:      {} ms", (Object)context.getConfiguredWarmUp());
        log.info("Ramp up:      {} ms", (Object)context.getConfiguredRampUpPeriodMs());
        log.info("");
        log.info("Execution time: {} ms", (Object)context.getConfiguredDuration());
        log.info("Throughput:     {}/s (Required: {}/s) - {}", new Object[]{context.getThroughputQps(), context.getRequiredThroughput(), throughputStatus});
        log.info("Min. latency:   {} ms (Required: {}ms) - {}", (Object)Float.valueOf(context.getMinLatencyMs()), (Object)FormatterUtils.format(context.getRequiredMinLatency()));
        log.info("Max. latency:    {} ms (Required: {}ms) - {}", (Object)Float.valueOf(context.getMaxLatencyMs()), (Object)FormatterUtils.format(context.getRequiredMaxLatency()));
        log.info("Ave. latency:    {} ms (Required: {}ms) - {}", (Object)Float.valueOf(context.getMeanLatencyMs()), (Object)FormatterUtils.format(context.getRequiredMeanLatency()));
        context.getRequiredPercentiles().forEach((percentile, threshold) -> {
            String percentileStatus = context.getPercentileResults().get(percentile) != false ? PASSED : FAILED;
            log.info("{}:    {}ms (Required: {} ms) - {}", new Object[]{percentile, Float.valueOf(context.getLatencyPercentileMs((int)percentile)), FormatterUtils.format(threshold.floatValue()), percentileStatus});
        });
        log.info("");
        log.info("");
    }

    @Override
    public String getReportPath() {
        return null;
    }
}

