/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.statements;

import com.github.noconnor.junitperf.statements.TestStatement;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

final class EvaluationTask
implements Runnable {
    private final TestStatement statement;
    private final RateLimiter rateLimiter;
    private final Supplier<Boolean> terminator;
    private final StatisticsCalculator stats;
    private final long warmUpPeriodNs;

    EvaluationTask(TestStatement statement, RateLimiter rateLimiter, StatisticsCalculator stats, int warmUpPeriodMs) {
        this(statement, rateLimiter, () -> Thread.currentThread().isInterrupted(), stats, warmUpPeriodMs);
    }

    EvaluationTask(TestStatement statement, RateLimiter rateLimiter, Supplier<Boolean> terminator, StatisticsCalculator stats, int warmUpPeriodMs) {
        this.statement = statement;
        this.rateLimiter = rateLimiter;
        this.terminator = terminator;
        this.stats = stats;
        this.warmUpPeriodNs = TimeUnit.NANOSECONDS.convert(warmUpPeriodMs > 0 ? (long)warmUpPeriodMs : 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        long startTimeNs = System.nanoTime();
        long startMeasurements = startTimeNs + this.warmUpPeriodNs;
        while (!this.terminator.get().booleanValue()) {
            this.waitForPermit();
            this.evaluateStatement(startMeasurements);
        }
    }

    private void evaluateStatement(long startMeasurements) {
        if (System.nanoTime() < startMeasurements) {
            try {
                this.statement.evaluate();
            }
            catch (Throwable throwable) {}
        } else {
            long startTimeNs = System.nanoTime();
            try {
                this.statement.evaluate();
                this.stats.addLatencyMeasurement(System.nanoTime() - startTimeNs);
                this.stats.incrementEvaluationCount();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                this.stats.incrementEvaluationCount();
                this.stats.incrementErrorCount();
                this.stats.addLatencyMeasurement(System.nanoTime() - startTimeNs);
            }
        }
    }

    private void waitForPermit() {
        if (Objects.nonNull(this.rateLimiter)) {
            this.rateLimiter.acquire();
        }
    }

    public static EvaluationTaskBuilder builder() {
        return new EvaluationTaskBuilder();
    }

    public static class EvaluationTaskBuilder {
        private TestStatement statement;
        private RateLimiter rateLimiter;
        private StatisticsCalculator stats;
        private int warmUpPeriodMs;

        EvaluationTaskBuilder() {
        }

        public EvaluationTaskBuilder statement(TestStatement statement) {
            this.statement = statement;
            return this;
        }

        public EvaluationTaskBuilder rateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        public EvaluationTaskBuilder stats(StatisticsCalculator stats) {
            this.stats = stats;
            return this;
        }

        public EvaluationTaskBuilder warmUpPeriodMs(int warmUpPeriodMs) {
            this.warmUpPeriodMs = warmUpPeriodMs;
            return this;
        }

        public EvaluationTask build() {
            return new EvaluationTask(this.statement, this.rateLimiter, this.stats, this.warmUpPeriodMs);
        }

        public String toString() {
            return "EvaluationTask.EvaluationTaskBuilder(statement=" + this.statement + ", rateLimiter=" + this.rateLimiter + ", stats=" + this.stats + ", warmUpPeriodMs=" + this.warmUpPeriodMs + ")";
        }
    }
}

