/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.statements;

import com.github.noconnor.junitperf.statements.EmptyStatement;
import com.github.noconnor.junitperf.statements.TestStatement;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runners.model.Statement;

public class MeasurableStatement
implements TestStatement {
    private RunBefores befores;
    private Statement statement;
    private RunAfters afters;

    public MeasurableStatement(Statement statement) {
        if (statement instanceof RunAfters) {
            this.decompose((RunAfters)statement);
        } else if (statement instanceof RunBefores) {
            this.decompose((RunBefores)statement);
        } else {
            this.befores = null;
            this.statement = statement;
            this.afters = null;
        }
    }

    public void runBefores() throws Throwable {
        if (Objects.nonNull(this.befores)) {
            this.befores.evaluate();
        }
    }

    public void evaluate() throws Throwable {
        this.statement.evaluate();
    }

    public void runAfters() throws Throwable {
        if (Objects.nonNull(this.afters)) {
            this.afters.evaluate();
        }
    }

    private void decompose(RunBefores befores) {
        try {
            Statement statement = this.captureStatement(befores);
            this.befores = this.decomposeBefores(befores);
            if (statement instanceof RunAfters) {
                this.afters = this.decomposeAfters((RunAfters)statement);
                this.statement = this.captureStatement((RunAfters)statement);
            } else {
                this.afters = null;
                this.statement = statement;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void decompose(RunAfters afters) {
        try {
            Statement statement = this.captureStatement(afters);
            this.afters = this.decomposeAfters(afters);
            if (statement instanceof RunBefores) {
                this.befores = this.decomposeBefores((RunBefores)statement);
                this.statement = this.captureStatement((RunBefores)statement);
            } else {
                this.befores = null;
                this.statement = statement;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private RunBefores decomposeBefores(RunBefores befores) throws NoSuchFieldException, IllegalAccessException {
        Field beforesField = RunBefores.class.getDeclaredField("befores");
        Field targetField = RunBefores.class.getDeclaredField("target");
        beforesField.setAccessible(true);
        targetField.setAccessible(true);
        return new RunBefores((Statement)new EmptyStatement(), (List)beforesField.get(befores), targetField.get(befores));
    }

    private RunAfters decomposeAfters(RunAfters afters) throws NoSuchFieldException, IllegalAccessException {
        Field aftersField = RunAfters.class.getDeclaredField("afters");
        Field targetField = RunAfters.class.getDeclaredField("target");
        aftersField.setAccessible(true);
        targetField.setAccessible(true);
        return new RunAfters((Statement)new EmptyStatement(), (List)aftersField.get(afters), targetField.get(afters));
    }

    private Statement captureStatement(RunAfters afters) throws NoSuchFieldException, IllegalAccessException {
        Field nextField = RunAfters.class.getDeclaredField("next");
        nextField.setAccessible(true);
        return (Statement)nextField.get(afters);
    }

    private Statement captureStatement(RunBefores befores) throws NoSuchFieldException, IllegalAccessException {
        Field nextField = RunBefores.class.getDeclaredField("next");
        nextField.setAccessible(true);
        return (Statement)nextField.get(befores);
    }
}

