/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.boot.autoconfigure.embedded.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.github.nosan.boot.autoconfigure.embedded.cassandra.EmbeddedCassandraProperties;
import com.github.nosan.embedded.cassandra.Cassandra;
import com.github.nosan.embedded.cassandra.CassandraBuilder;
import com.github.nosan.embedded.cassandra.CassandraBuilderConfigurator;
import com.github.nosan.embedded.cassandra.commons.Resource;
import com.github.nosan.embedded.cassandra.commons.UrlResource;
import com.github.nosan.embedded.cassandra.commons.logging.Logger;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AbstractDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={EmbeddedCassandraProperties.class})
@AutoConfigureBefore(value={CassandraAutoConfiguration.class})
@ConditionalOnClass(value={Cassandra.class})
@Import(value={CassandraCqlSessionDependsOnPostProcessor.class})
public class EmbeddedCassandraAutoConfiguration {
    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    Cassandra embeddedCassandra(CassandraBuilder embeddedCassandraBuilder) {
        return embeddedCassandraBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    CassandraBuilder embeddedCassandraBuilder(EmbeddedCassandraProperties properties, ObjectProvider<CassandraBuilderConfigurator> configurators) throws IOException {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        CassandraBuilder builder = new CassandraBuilder();
        builder.addEnvironmentVariables(properties.getEnvironmentVariables());
        builder.addSystemProperties(properties.getSystemProperties());
        builder.addConfigProperties(properties.getConfigProperties());
        builder.addJvmOptions(properties.getJvmOptions());
        map.from(properties::getRegisterShutdownHook).to(arg_0 -> ((CassandraBuilder)builder).registerShutdownHook(arg_0));
        map.from(properties::getVersion).whenHasText().to(arg_0 -> ((CassandraBuilder)builder).version(arg_0));
        map.from(properties::getLogger).whenHasText().as(Logger::get).to(arg_0 -> ((CassandraBuilder)builder).logger(arg_0));
        map.from(properties::getName).whenHasText().to(arg_0 -> ((CassandraBuilder)builder).name(arg_0));
        map.from(properties::getWorkingDirectory).to(workingDirectory -> builder.workingDirectory(() -> workingDirectory));
        map.from(properties::getStartupTimeout).whenNot(Duration::isNegative).whenNot(Duration::isZero).to(arg_0 -> ((CassandraBuilder)builder).startupTimeout(arg_0));
        org.springframework.core.io.Resource configFile = properties.getConfigFile();
        if (configFile != null) {
            builder.configFile((Resource)new UrlResource(configFile.getURL()));
        }
        for (Map.Entry<String, org.springframework.core.io.Resource> entry : properties.getWorkingDirectoryResources().entrySet()) {
            builder.addWorkingDirectoryResource((Resource)new UrlResource(entry.getValue().getURL()), entry.getKey());
        }
        configurators.orderedStream().forEach(arg_0 -> ((CassandraBuilder)builder).configure(arg_0));
        return builder;
    }

    @ConditionalOnClass(value={CqlSession.class})
    static class CassandraCqlSessionDependsOnPostProcessor
    extends AbstractDependsOnBeanFactoryPostProcessor {
        CassandraCqlSessionDependsOnPostProcessor() {
            super(CqlSession.class, new Class[]{Cassandra.class});
        }
    }
}

