/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.Process;
import com.github.nosan.embedded.cassandra.Version;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

interface CassandraDatabase {
    public void start() throws IOException;

    public void stop() throws IOException;

    public boolean isAlive();

    public CompletableFuture<? extends CassandraDatabase> onExit();

    public String getName();

    public Map<String, String> getEnvironmentVariables();

    public Map<String, Object> getConfigProperties();

    public Map<String, String> getSystemProperties();

    public Set<String> getJvmOptions();

    public Version getVersion();

    public Path getWorkingDirectory();

    public Path getConfigurationFile();

    public Process.Output getStdOut();

    public Process.Output getStdErr();
}

