/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.Cassandra;
import com.github.nosan.embedded.cassandra.CassandraDatabase;
import com.github.nosan.embedded.cassandra.CassandraDatabaseFactory;
import com.github.nosan.embedded.cassandra.CassandraException;
import com.github.nosan.embedded.cassandra.DefaultSettings;
import com.github.nosan.embedded.cassandra.ErrorCollector;
import com.github.nosan.embedded.cassandra.NativeTransportParser;
import com.github.nosan.embedded.cassandra.OutputCollector;
import com.github.nosan.embedded.cassandra.RpcTransportParser;
import com.github.nosan.embedded.cassandra.Settings;
import com.github.nosan.embedded.cassandra.StartupParser;
import com.github.nosan.embedded.cassandra.Version;
import com.github.nosan.embedded.cassandra.WorkingDirectoryCustomizer;
import com.github.nosan.embedded.cassandra.WorkingDirectoryDestroyer;
import com.github.nosan.embedded.cassandra.WorkingDirectoryInitializer;
import com.github.nosan.embedded.cassandra.commons.logging.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class DefaultCassandra
implements Cassandra {
    private static final Logger LOGGER = Logger.get(DefaultCassandra.class);
    private final String name;
    private final Version version;
    private final boolean registerShutdownHook;
    private final Path workingDirectory;
    private final Set<WorkingDirectoryCustomizer> workingDirectoryCustomizers;
    private final WorkingDirectoryInitializer workingDirectoryInitializer;
    private final WorkingDirectoryDestroyer workingDirectoryDestroyer;
    private final Duration startupTimeout;
    private final Object lock = new Object();
    private final CassandraDatabaseFactory databaseFactory;
    private final Logger logger;
    private volatile boolean started = false;
    private volatile boolean running = false;
    private volatile Thread shutdownHookThread;
    private volatile CassandraDatabase database;
    private volatile Settings settings;

    DefaultCassandra(String name, Version version, Path workingDirectory, boolean registerShutdownHook, WorkingDirectoryInitializer workingDirectoryInitializer, WorkingDirectoryDestroyer workingDirectoryDestroyer, Duration startupTimeout, Set<WorkingDirectoryCustomizer> workingDirectoryCustomizers, CassandraDatabaseFactory databaseFactory, Logger logger) {
        this.name = name;
        this.version = version;
        this.startupTimeout = startupTimeout;
        this.workingDirectoryInitializer = workingDirectoryInitializer;
        this.registerShutdownHook = registerShutdownHook;
        this.workingDirectory = workingDirectory;
        this.workingDirectoryDestroyer = workingDirectoryDestroyer;
        this.databaseFactory = databaseFactory;
        this.workingDirectoryCustomizers = Collections.unmodifiableSet(workingDirectoryCustomizers);
        this.logger = logger;
    }

    @Override
    public synchronized void start() throws CassandraException {
        if (this.started) {
            return;
        }
        this.settings = null;
        this.running = false;
        this.database = null;
        this.init();
        this.doStart();
        this.await();
        this.database.onExit().thenRun(this::doStop);
    }

    @Override
    public synchronized void stop() throws CassandraException {
        if (!this.started) {
            return;
        }
        this.doStop();
    }

    @Override
    public synchronized Settings getSettings() {
        Settings settings = this.settings;
        if (settings == null) {
            throw new IllegalStateException("The getSettings() method was called but start() had not been called");
        }
        return settings;
    }

    @Override
    public boolean isRunning() {
        CassandraDatabase database = this.database;
        return this.running && database != null && database.isAlive();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String toString() {
        return "DefaultCassandra{name='" + this.name + "', version='" + this.version + "'}";
    }

    private void init() {
        Version version = this.version;
        try {
            Files.createDirectories(this.workingDirectory, new FileAttribute[0]);
            this.workingDirectoryInitializer.init(this.workingDirectory, version);
            for (WorkingDirectoryCustomizer workingDirectoryCustomizer : this.workingDirectoryCustomizers) {
                workingDirectoryCustomizer.customize(this.workingDirectory, version);
            }
            this.database = this.databaseFactory.create(this.workingDirectory);
        }
        catch (Exception ex) {
            this.destroyWorkingDirectory();
            throw new CassandraException(String.format("Unable to initialize %s. Caused by: %s", this, ex), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.started = true;
                this.addShutdownHook();
                this.database.start();
            }
            catch (Exception ex) {
                try {
                    this.doStop();
                }
                catch (Exception suppressed) {
                    ex.addSuppressed(suppressed);
                }
                throw new CassandraException(String.format("Unable to start %s. Caused by: %s", this, ex), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            CassandraDatabase database = this.database;
            if (database != null) {
                try {
                    database.stop();
                }
                catch (Exception ex) {
                    throw new CassandraException(String.format("Unable to stop %s. Caused by: %s", this, ex), ex);
                }
            }
            this.destroyWorkingDirectory();
            this.removeShutdownHook();
            this.started = false;
            this.running = false;
            this.database = null;
        }
    }

    private void await() {
        CassandraDatabase database = this.database;
        Duration timeout = this.startupTimeout;
        database.getStdOut().attach(this.logger::info);
        database.getStdErr().attach(this.logger::error);
        try (NativeTransportParser nativeTransport = new NativeTransportParser(database);
             RpcTransportParser rpcTransport = new RpcTransportParser(database);
             OutputCollector outputCollector = new OutputCollector(database);
             ErrorCollector errorCollector = new ErrorCollector(database);
             StartupParser startup = new StartupParser(database);){
            long start = System.nanoTime();
            long rem = timeout.toNanos();
            while (!(rem <= 0L || !database.isAlive() || nativeTransport.isParsed() && rpcTransport.isParsed() && startup.isComplete())) {
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                rem = timeout.toNanos() - (System.nanoTime() - start);
            }
            while (!(rem <= 0L || !database.isAlive() || DefaultCassandra.connect(nativeTransport) && DefaultCassandra.connect(rpcTransport))) {
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                rem = timeout.toNanos() - (System.nanoTime() - start);
            }
            if (!database.isAlive() || nativeTransport.isFailed() || rpcTransport.isFailed()) {
                StringBuilder message = new StringBuilder(String.format("'%s' is not alive.", database)).append(" Please see logs for more details.");
                List<String> errors = errorCollector.getErrors();
                if (!errors.isEmpty()) {
                    message.append(String.format("%nErrors:%n%s", String.join((CharSequence)System.lineSeparator(), errors)));
                }
                message.append(String.format("%nOutput:%n%s", String.join((CharSequence)System.lineSeparator(), outputCollector.getOutput())));
                throw new IOException(message.toString());
            }
            if (rem <= 0L) {
                throw new IllegalStateException(String.format("%s couldn't be started within %sms", database, this.startupTimeout.toMillis()));
            }
            InetAddress address = Optional.ofNullable(nativeTransport.getAddress()).orElseGet(rpcTransport::getAddress);
            this.settings = new DefaultSettings(database.getName(), database.getVersion(), address, nativeTransport.isStarted(), nativeTransport.getPort(), nativeTransport.getSslPort(), rpcTransport.isStarted(), rpcTransport.getPort(), database.getConfigurationFile(), database.getWorkingDirectory(), database.getJvmOptions(), database.getSystemProperties(), database.getEnvironmentVariables(), database.getConfigProperties());
            this.running = true;
        }
        catch (Exception ex) {
            try {
                this.doStop();
            }
            catch (Exception suppressed) {
                ex.addSuppressed(suppressed);
            }
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new CassandraException(String.format("Unable to await %s. Caused by: %s", this, ex), ex);
        }
    }

    private void addShutdownHook() {
        if (this.registerShutdownHook && this.shutdownHookThread == null) {
            Thread thread = new Thread(this::doStop, this.name + "-sh");
            Runtime.getRuntime().addShutdownHook(thread);
            this.shutdownHookThread = thread;
        }
    }

    private void removeShutdownHook() {
        Thread shutdownHookThread = this.shutdownHookThread;
        if (shutdownHookThread != null && shutdownHookThread != Thread.currentThread()) {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
                this.shutdownHookThread = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void destroyWorkingDirectory() {
        try {
            this.workingDirectoryDestroyer.destroy(this.workingDirectory, this.version);
        }
        catch (Exception ex) {
            LOGGER.error(ex, "Working directory: ''{0}'' could not be destroyed", this.workingDirectory);
        }
    }

    private static boolean connect(NativeTransportParser nativeTransport) {
        if (!nativeTransport.isStarted()) {
            return true;
        }
        InetAddress address = nativeTransport.getAddress();
        if (nativeTransport.getSslPort() != null) {
            return DefaultCassandra.connect(address, nativeTransport.getPort()) && DefaultCassandra.connect(address, nativeTransport.getSslPort());
        }
        return DefaultCassandra.connect(address, nativeTransport.getPort());
    }

    private static boolean connect(RpcTransportParser rpcTransport) {
        if (!rpcTransport.isStarted()) {
            return true;
        }
        return DefaultCassandra.connect(rpcTransport.getAddress(), rpcTransport.getPort());
    }

    private static boolean connect(InetAddress address, int port) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(address, port), 100);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        socket.close();
        return bl;
    }
}

