/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.Process;
import com.github.nosan.embedded.cassandra.commons.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

final class DefaultProcess
implements Process {
    private static final Logger LOGGER = Logger.get(DefaultProcess.class);
    private final String name;
    private final java.lang.Process process;
    private final ProcessOutput stdout;
    private final ProcessOutput stderr;

    DefaultProcess(String name, java.lang.Process process) {
        this.name = name;
        this.process = process;
        this.stdout = new ProcessOutput(name + ":OUT", process.getInputStream());
        this.stderr = new ProcessOutput(name + ":ERR", process.getErrorStream());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getPid() {
        try {
            return Pid.get(this.process);
        }
        catch (Exception ex) {
            LOGGER.error(ex, "Could not get a PID of a process: ''{0}''", this.process);
            return -1L;
        }
    }

    @Override
    public Process destroy() {
        this.process.destroy();
        return this;
    }

    @Override
    public Process destroyForcibly() {
        this.process.destroyForcibly();
        return this;
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public int waitFor() {
        boolean interrupted = false;
        while (true) {
            try {
                int n = this.process.waitFor();
                return n;
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean waitFor(int timeout, TimeUnit unit) {
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    boolean bl = this.process.waitFor(remainingNanos, TimeUnit.NANOSECONDS);
                    return bl;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public CompletableFuture<? extends Process> onExit() {
        final java.lang.Process process = this.process;
        return CompletableFuture.supplyAsync(() -> {
            boolean interrupted = false;
            while (true) {
                try {
                    ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                        @Override
                        public boolean block() throws InterruptedException {
                            process.waitFor();
                            return true;
                        }

                        @Override
                        public boolean isReleasable() {
                            return !process.isAlive();
                        }
                    });
                }
                catch (InterruptedException x) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return this;
        });
    }

    @Override
    public Process.Output getStdOut() {
        return this.stdout;
    }

    @Override
    public Process.Output getStdErr() {
        return this.stderr;
    }

    public String toString() {
        return this.process.toString();
    }

    private static final class Pid {
        private Pid() {
        }

        private static long get(java.lang.Process process) throws InvocationTargetException, IllegalAccessException {
            try {
                Method method = java.lang.Process.class.getMethod("pid", new Class[0]);
                return Pid.getLong(method.invoke((Object)process, new Object[0]));
            }
            catch (NoSuchMethodException method) {
                try {
                    Field field = process.getClass().getDeclaredField("pid");
                    field.setAccessible(true);
                    return Pid.getLong(field.get(process));
                }
                catch (NoSuchFieldException ex) {
                    return -1L;
                }
            }
        }

        private static long getLong(Object result) {
            return Long.parseLong(Objects.toString(result, "-1").trim());
        }
    }

    private static final class ProcessOutput
    extends Thread
    implements Process.Output {
        private static final Logger LOGGER = Logger.get(ProcessOutput.class);
        private final List<Consumer<? super String>> consumers = new CopyOnWriteArrayList<Consumer<? super String>>();
        private final AtomicBoolean started = new AtomicBoolean(false);
        private final InputStream is;

        ProcessOutput(String name, InputStream is) {
            super(name);
            this.is = is;
            this.setDaemon(true);
            this.setUncaughtExceptionHandler((thread, ex) -> LOGGER.error(ex, "Exception in thread: ''{0}''", thread));
        }

        @Override
        public void run() {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));){
                String line;
                while ((line = ProcessOutput.readLine(bufferedReader)) != null) {
                    for (Consumer<? super String> consumer : this.consumers) {
                        consumer.accept(line);
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Override
        public void attach(Consumer<? super String> consumer) {
            this.doStart();
            this.consumers.add(consumer);
        }

        @Override
        public void detach(Consumer<? super String> consumer) {
            this.consumers.remove(consumer);
        }

        private void doStart() {
            if (this.started.compareAndSet(false, true)) {
                this.start();
            }
        }

        private static String readLine(BufferedReader reader) throws IOException {
            try {
                return reader.readLine();
            }
            catch (IOException ex) {
                if (Objects.toString(ex.getMessage(), "").contains("Stream closed")) {
                    return null;
                }
                throw ex;
            }
        }
    }
}

