/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.Settings;
import com.github.nosan.embedded.cassandra.Version;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DefaultSettings
implements Settings {
    private final String name;
    private final Version version;
    private final InetAddress address;
    private final boolean nativeTransportEnabled;
    private final boolean rpcTransportEnabled;
    private final Integer port;
    private final Integer rpcPort;
    private final Integer sslPort;
    private final Path configurationFile;
    private final Path workingDirectory;
    private final Set<String> jvmOptions;
    private final Map<String, String> systemProperties;
    private final Map<String, String> environmentVariables;
    private final Map<String, Object> configProperties;

    DefaultSettings(String name, Version version, InetAddress address, boolean nativeTransportEnabled, Integer port, Integer sslPort, boolean rpcTransportEnabled, Integer rpcPort, Path configurationFile, Path workingDirectory, Set<String> jvmOptions, Map<String, String> systemProperties, Map<String, String> environmentVariables, Map<String, Object> configProperties) {
        this.name = name;
        this.version = version;
        this.nativeTransportEnabled = nativeTransportEnabled;
        this.rpcTransportEnabled = rpcTransportEnabled;
        this.rpcPort = rpcPort;
        this.configurationFile = configurationFile;
        this.environmentVariables = DefaultSettings.readOnly(environmentVariables);
        this.systemProperties = DefaultSettings.readOnly(systemProperties);
        this.jvmOptions = DefaultSettings.readOnly(jvmOptions);
        this.configProperties = DefaultSettings.readOnly(configProperties);
        this.address = address;
        this.port = port;
        this.sslPort = sslPort;
        this.workingDirectory = workingDirectory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean isNativeTransportEnabled() {
        return this.nativeTransportEnabled;
    }

    @Override
    public boolean isRpcTransportEnabled() {
        return this.rpcTransportEnabled;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public Integer getPort() {
        if (this.port == null) {
            return this.getSslPort();
        }
        return this.port;
    }

    @Override
    public Integer getRpcPort() {
        return this.rpcPort;
    }

    @Override
    public Path getConfigurationFile() {
        return this.configurationFile;
    }

    @Override
    public Integer getSslPort() {
        return this.sslPort;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public Set<String> getJvmOptions() {
        return this.jvmOptions;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    private static <T> T readOnly(T object) {
        if (object instanceof Map) {
            LinkedHashMap result = new LinkedHashMap();
            ((Map)object).forEach((name, value) -> result.put(name, DefaultSettings.readOnly(value)));
            return (T)Collections.unmodifiableMap(result);
        }
        if (object instanceof List) {
            ArrayList result = new ArrayList();
            ((List)object).forEach(each -> result.add(DefaultSettings.readOnly(each)));
            return (T)Collections.unmodifiableList(result);
        }
        if (object instanceof Set) {
            LinkedHashSet result = new LinkedHashSet();
            ((Set)object).forEach(each -> result.add(DefaultSettings.readOnly(each)));
            return (T)Collections.unmodifiableSet(result);
        }
        return object;
    }
}

