/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.CassandraDirectoryProvider;
import com.github.nosan.embedded.cassandra.Version;
import com.github.nosan.embedded.cassandra.WorkingDirectoryInitializer;
import com.github.nosan.embedded.cassandra.commons.FileUtils;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class DefaultWorkingDirectoryInitializer
implements WorkingDirectoryInitializer {
    private static final Set<String> SKIP_DIRECTORIES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("javadoc", "doc", "licenses")));
    private final CassandraDirectoryProvider cassandraDirectoryProvider;
    private final CopyStrategy copyStrategy;

    public DefaultWorkingDirectoryInitializer(CassandraDirectoryProvider cassandraDirectoryProvider) {
        this(cassandraDirectoryProvider, CopyStrategy.REPLACE_EXISTING);
    }

    public DefaultWorkingDirectoryInitializer(CassandraDirectoryProvider cassandraDirectoryProvider, CopyStrategy copyStrategy) {
        Objects.requireNonNull(cassandraDirectoryProvider, "Cassandra Directory Provider must not be null");
        Objects.requireNonNull(copyStrategy, "Copy Option must not be null");
        this.cassandraDirectoryProvider = cassandraDirectoryProvider;
        this.copyStrategy = copyStrategy;
    }

    @Override
    public final void init(Path workingDirectory, Version version) throws IOException {
        Objects.requireNonNull(workingDirectory, "Working Directory must not be null");
        Objects.requireNonNull(version, "Version must not be null");
        Path cassandraDirectory = this.cassandraDirectoryProvider.getDirectory(version);
        Objects.requireNonNull(cassandraDirectory, "Cassandra Directory must not be null");
        this.copy(cassandraDirectory, workingDirectory, this.copyStrategy);
    }

    protected void copy(Path cassandraDirectory, Path workingDirectory, CopyStrategy copyStrategy) throws IOException {
        if (copyStrategy == CopyStrategy.REPLACE_EXISTING) {
            FileUtils.copy(cassandraDirectory, workingDirectory, (path, attributes) -> {
                if (attributes.isDirectory()) {
                    return !SKIP_DIRECTORIES.contains(path.getFileName().toString());
                }
                return true;
            }, StandardCopyOption.REPLACE_EXISTING);
        } else {
            FileUtils.copy(cassandraDirectory, workingDirectory, (path, attributes) -> {
                if (attributes.isDirectory()) {
                    return !SKIP_DIRECTORIES.contains(path.getFileName().toString());
                }
                return !Files.exists(workingDirectory.resolve(cassandraDirectory.relativize((Path)path)), new LinkOption[0]);
            }, new CopyOption[0]);
        }
    }

    public static enum CopyStrategy {
        REPLACE_EXISTING,
        SKIP_EXISTING;

    }
}

