/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.CassandraDatabase;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

class ErrorCollector
implements Consumer<String>,
Closeable {
    private final List<String> errors = new CopyOnWriteArrayList<String>();
    private final CassandraDatabase database;

    ErrorCollector(CassandraDatabase database) {
        this.database = database;
        database.getStdErr().attach(this);
    }

    @Override
    public void accept(String line) {
        this.errors.add(line);
    }

    @Override
    public void close() {
        this.database.getStdErr().detach(this);
    }

    List<String> getErrors() {
        return this.errors;
    }
}

