/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.CassandraDatabase;
import java.io.Closeable;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;

class OutputCollector
implements Consumer<String>,
Closeable {
    private final Deque<String> output = new ConcurrentLinkedDeque<String>();
    private final CassandraDatabase database;

    OutputCollector(CassandraDatabase database) {
        this.database = database;
        database.getStdOut().attach(this);
    }

    @Override
    public void accept(String line) {
        while (this.output.size() >= 30) {
            this.output.removeFirst();
        }
        this.output.addLast(line);
    }

    @Override
    public void close() {
        this.database.getStdOut().detach(this);
    }

    Deque<String> getOutput() {
        return this.output;
    }
}

