/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.CassandraBuilder;
import com.github.nosan.embedded.cassandra.CassandraBuilderConfigurator;
import com.github.nosan.embedded.cassandra.commons.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class SimpleSeedProviderConfigurator
implements CassandraBuilderConfigurator {
    private static final String SIMPLE_SEED_PROVIDER_CLASS = "org.apache.cassandra.locator.SimpleSeedProvider";
    private final Set<String> addresses = new LinkedHashSet<String>();

    public SimpleSeedProviderConfigurator(String ... addresses) {
        SimpleSeedProviderConfigurator.checkAddress(addresses);
        this.addresses.addAll(Arrays.asList(addresses));
    }

    public SimpleSeedProviderConfigurator seeds(String ... addresses) {
        SimpleSeedProviderConfigurator.checkAddress(addresses);
        this.addresses.clear();
        this.addresses.addAll(Arrays.asList(addresses));
        return this;
    }

    public SimpleSeedProviderConfigurator addSeeds(String ... addresses) {
        SimpleSeedProviderConfigurator.checkAddress(addresses);
        this.addresses.addAll(Arrays.asList(addresses));
        return this;
    }

    public SimpleSeedProviderConfigurator addSeed(String address, int port) {
        SimpleSeedProviderConfigurator.checkAddress(address);
        SimpleSeedProviderConfigurator.checkPort(port);
        return this.addSeeds(SimpleSeedProviderConfigurator.getAddress(address, port));
    }

    @Override
    public void configure(CassandraBuilder builder) {
        Objects.requireNonNull(builder, "Cassandra Builder must not be null");
        if (this.addresses.isEmpty()) {
            throw new IllegalArgumentException("No seeds!");
        }
        String seeds = String.join((CharSequence)",", this.addresses);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("class_name", SIMPLE_SEED_PROVIDER_CLASS);
        result.put("parameters", Collections.singletonList(Collections.singletonMap("seeds", seeds)));
        builder.addConfigProperty("seed_provider", Collections.singletonList(result));
    }

    private static void checkAddress(String ... addresses) {
        Objects.requireNonNull(addresses, "Addresses must not be null");
        for (String address : addresses) {
            if (StringUtils.hasText(address)) continue;
            throw new IllegalArgumentException("Address must not be null or empty");
        }
    }

    private static void checkPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port out of range: " + port);
        }
    }

    private static String getAddress(String address, int port) {
        StringBuilder r = new StringBuilder(address);
        if (address.contains(":")) {
            if (r.charAt(0) != '[') {
                r.insert(0, '[');
            }
            if (r.charAt(r.length() - 1) != ']') {
                r.append(']');
            }
        }
        return r.append(':').append(port).toString();
    }
}

