/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.AbstractCassandraDatabase;
import com.github.nosan.embedded.cassandra.DefaultProcess;
import com.github.nosan.embedded.cassandra.Process;
import com.github.nosan.embedded.cassandra.Version;
import com.github.nosan.embedded.cassandra.commons.logging.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class UnixCassandraDatabase
extends AbstractCassandraDatabase {
    private static final Logger LOGGER = Logger.get(UnixCassandraDatabase.class);

    UnixCassandraDatabase(String name, Version version, Path configurationFile, Path workingDirectory, Map<String, String> environmentVariables, Map<String, Object> configProperties, Map<String, String> systemProperties, Set<String> jvmOptions) {
        super(name, version, configurationFile, workingDirectory, environmentVariables, configProperties, systemProperties, jvmOptions);
    }

    @Override
    protected Process doStart() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(this.getWorkingDirectory().toFile());
        processBuilder.environment().putAll(this.getEnvironmentVariables());
        Path executable = this.getWorkingDirectory().resolve("bin/cassandra");
        if (!Files.exists(executable, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("%s does not exist", executable));
        }
        this.setExecutable(executable);
        ArrayList<String> command = new ArrayList<String>();
        command.add(executable.toString());
        if (this.getVersion().compareTo(Version.parse("3.1")) > 0) {
            command.add("-R");
        }
        command.add("-f");
        return this.start(this.getName() + ":bin/cassandra", processBuilder.command(command));
    }

    @Override
    protected void doStop(Process process) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(this.getWorkingDirectory().toFile());
        processBuilder.environment().putAll(this.getEnvironmentVariables());
        long pid = process.getPid();
        if (pid > 0L && this.kill(processBuilder, pid) == 0 && process.waitFor(10, TimeUnit.SECONDS)) {
            return;
        }
        if (pid > 0L && this.sigkill(processBuilder, pid) == 0 && process.waitFor(10, TimeUnit.SECONDS)) {
            return;
        }
        process.destroy();
    }

    void setExecutable(Path executable) throws IOException {
        if (!Files.isExecutable(executable)) {
            LinkedHashSet<PosixFilePermission> permissions = new LinkedHashSet<PosixFilePermission>(Files.getPosixFilePermissions(executable, new LinkOption[0]));
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
            Files.setPosixFilePermissions(executable, permissions);
        }
    }

    Process start(String name, ProcessBuilder processBuilder) throws IOException {
        LOGGER.info("[{0}] {1}", name, String.join((CharSequence)" ", processBuilder.command()));
        return new DefaultProcess(name, processBuilder.start());
    }

    int exec(String name, ProcessBuilder processBuilder) throws IOException {
        Process process = this.start(name, processBuilder);
        process.getStdOut().attach(LOGGER::info);
        process.getStdErr().attach(LOGGER::error);
        return process.waitFor();
    }

    private int kill(ProcessBuilder processBuilder, long pid) throws IOException {
        String name = this.getName() + ":kill";
        ArrayList<String> command = new ArrayList<String>();
        command.add("kill");
        command.add("-SIGINT");
        command.add(Long.toString(pid));
        return this.exec(name, processBuilder.command(command));
    }

    private int sigkill(ProcessBuilder processBuilder, long pid) throws IOException {
        String name = this.getName() + ":kill";
        ArrayList<String> command = new ArrayList<String>();
        command.add("kill");
        command.add("-SIGKILL");
        command.add(Long.toString(pid));
        return this.exec(name, processBuilder.command(command));
    }
}

