/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.Version;
import com.github.nosan.embedded.cassandra.commons.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

@FunctionalInterface
public interface WorkingDirectoryCustomizer {
    public static WorkingDirectoryCustomizer addResource(Resource resource, String path) {
        Objects.requireNonNull(path, "File Path must not be null");
        Objects.requireNonNull(resource, "Resource must not be null");
        return (workingDirectory, version) -> {
            Objects.requireNonNull(workingDirectory, "Working Directory must not be null");
            Objects.requireNonNull(version, "Version must not be null");
            Path normalizedPath = workingDirectory.resolve(path).normalize();
            if (!normalizedPath.startsWith(workingDirectory)) {
                throw new IllegalArgumentException("Path: '" + normalizedPath + "' is out of a directory: '" + workingDirectory + "'");
            }
            if (Files.isDirectory(normalizedPath, new LinkOption[0])) {
                throw new IllegalArgumentException("Path: '" + normalizedPath + "' is a directory");
            }
            Path parent = normalizedPath.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (InputStream is = resource.getInputStream();){
                Files.copy(is, normalizedPath, StandardCopyOption.REPLACE_EXISTING);
            }
        };
    }

    public void customize(Path var1, Version var2) throws IOException;
}

