/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons;

import com.github.nosan.embedded.cassandra.commons.Resource;
import com.github.nosan.embedded.cassandra.commons.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Objects;
import java.util.Optional;

public class ClassPathResource
implements Resource {
    private final String path;
    private final ClassLoader classLoader;

    public ClassPathResource(String path) {
        this(path, null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        Objects.requireNonNull(path, "Name must not be null");
        if (!StringUtils.hasText(path)) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        this.path = ClassPathResource.clean(path);
        this.classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
    }

    @Override
    public Optional<String> getFileName() {
        return Optional.of(this.getFilename()).filter(StringUtils::hasText);
    }

    @Override
    public boolean exists() {
        return this.getURL() != null;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isReadable() {
        try {
            this.getInputStream().close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection connection = this.toURL().openConnection();
        connection.setDoInput(true);
        return connection.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("protocol doesn't support output");
    }

    @Override
    public URL toURL() throws FileNotFoundException {
        URL url = this.getURL();
        if (url == null) {
            throw new FileNotFoundException(String.format("Classpath resource with a name '%s' does not exist", this.path));
        }
        return url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassPathResource that = (ClassPathResource)other;
        return this.path.equals(that.path) && Objects.equals(this.classLoader, that.classLoader);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.classLoader);
    }

    public String toString() {
        return "ClassPathResource{name='" + this.path + '\'' + '}';
    }

    public String getPath() {
        return this.path;
    }

    private URL getURL() {
        ClassLoader cl = this.classLoader;
        return cl != null ? cl.getResource(this.path) : ClassLoader.getSystemResource(this.path);
    }

    private String getFilename() {
        String name = this.path;
        int index = name.lastIndexOf(47);
        return index != -1 ? name.substring(index + 1) : name;
    }

    private static String clean(String name) {
        String path = name.trim().replace('\\', '/');
        return path.startsWith("/") ? path.substring(1) : path;
    }
}

