/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public final class FileLock
implements AutoCloseable {
    private final FileChannel fileChannel;
    private final Map<Thread, java.nio.channels.FileLock> locks = new ConcurrentHashMap<Thread, java.nio.channels.FileLock>();

    private FileLock(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public static FileLock of(Path file) throws IOException {
        Objects.requireNonNull(file, "File must not be null");
        return new FileLock(FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
    }

    public synchronized boolean tryLock(long timeout, TimeUnit timeUnit) throws FileLockInterruptionException, IOException {
        Objects.requireNonNull(timeUnit, "TimeUnit must not be null");
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        java.nio.channels.FileLock fileLock = this.locks.get(Thread.currentThread());
        if (fileLock != null && fileLock.isValid()) {
            return true;
        }
        long startTime = System.nanoTime();
        long rem = timeUnit.toNanos(timeout);
        do {
            if ((fileLock = FileLock.lock(this.fileChannel)) != null) {
                this.locks.put(Thread.currentThread(), fileLock);
                return true;
            }
            if (rem <= 0L) continue;
            try {
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
            }
            catch (InterruptedException ex) {
                throw new FileLockInterruptionException();
            }
        } while ((rem = timeUnit.toNanos(timeout) - (System.nanoTime() - startTime)) > 0L);
        return false;
    }

    @Override
    public synchronized void close() throws IOException {
        this.fileChannel.close();
        this.locks.clear();
    }

    private static java.nio.channels.FileLock lock(FileChannel fileChannel) throws IOException {
        try {
            return fileChannel.tryLock();
        }
        catch (OverlappingFileLockException ex) {
            return null;
        }
    }
}

