/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.function.BiPredicate;

public final class FileUtils {
    private static final char[] HEX_CODE = "0123456789abcdef".toCharArray();
    private static final int BUFFER_SIZE = 8192;

    private FileUtils() {
    }

    public static boolean delete(Path path) throws IOException {
        if (path == null) {
            return false;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
                if (ex != null) {
                    throw ex;
                }
                Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return true;
    }

    public static void copy(Path src, Path dest, CopyOption ... options) throws IOException {
        FileUtils.copy(src, dest, (? super Path path, ? super BasicFileAttributes attributes) -> true, options);
    }

    public static void copy(final Path src, final Path dest, final BiPredicate<? super Path, ? super BasicFileAttributes> filter, final CopyOption ... options) throws IOException {
        Objects.requireNonNull(src, "Source Path must not be null");
        Objects.requireNonNull(dest, "Destination Path must not be null");
        Objects.requireNonNull(options, "Copy Options must not be null");
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attrs) throws IOException {
                if (filter == null || filter.test(directory, attrs)) {
                    Files.createDirectories(dest.resolve(src.relativize(directory)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (filter == null || filter.test(file, attrs)) {
                    Files.copy(file, dest.resolve(src.relativize(file)), options);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String checksum(Path file, String algorithm) throws NoSuchAlgorithmException, IOException {
        Objects.requireNonNull(file, "File must not be null");
        Objects.requireNonNull(file, "Algorithm must not be null");
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] buffer = new byte[8192];
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            int read;
            while ((read = is.read(buffer)) != -1) {
                md.update(buffer, 0, read);
            }
        }
        byte[] data = md.digest();
        StringBuilder hex = new StringBuilder(data.length * 2);
        for (byte b : data) {
            hex.append(HEX_CODE[b >> 4 & 0xF]);
            hex.append(HEX_CODE[b & 0xF]);
        }
        return hex.toString();
    }
}

