/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons.logging;

import com.github.nosan.embedded.cassandra.commons.logging.Logger;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Objects;

public class ConsoleLogger
implements Logger {
    private final String name;

    public ConsoleLogger(String name) {
        Objects.requireNonNull(name, "Logger name must not be null");
        this.name = name;
    }

    @Override
    public synchronized void error(String message, Object ... args) {
        System.err.format("%s [%s] ERROR %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
    }

    @Override
    public synchronized void error(Throwable throwable, String message) {
        System.err.format("%s [%s] ERROR %s - %s%n", this.getNow(), this.getThread(), this.name, message);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    @Override
    public synchronized void error(Throwable throwable, String message, Object ... args) {
        System.err.format("%s [%s] ERROR %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public synchronized void error(String message) {
        System.err.format("%s [%s] ERROR %s - %s%n", this.getNow(), this.getThread(), this.name, message);
    }

    @Override
    public synchronized void warn(String message, Object ... args) {
        System.out.format("%s [%s] WARN %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
    }

    @Override
    public synchronized void warn(Throwable throwable, String message) {
        System.out.format("%s [%s] WARN %s - %s%n", this.getNow(), this.getThread(), this.name, message);
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public synchronized void warn(Throwable throwable, String message, Object ... args) {
        System.out.format("%s [%s] WARN %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public synchronized void warn(String message) {
        System.out.format("%s [%s] WARN %s - %s%n", this.getNow(), this.getThread(), this.name, message);
    }

    @Override
    public synchronized void info(String message, Object ... args) {
        System.out.format("%s [%s] INFO %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
    }

    @Override
    public synchronized void info(Throwable throwable, String message) {
        System.out.format("%s [%s] INFO %s - %s%n", this.getNow(), this.getThread(), this.name, message);
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public synchronized void info(Throwable throwable, String message, Object ... args) {
        System.out.format("%s [%s] INFO %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public synchronized void info(String message) {
        System.out.format("%s [%s] INFO %s - %s%n", this.getNow(), this.getThread(), this.name, message);
    }

    @Override
    public synchronized void debug(String message, Object ... args) {
        System.out.format("%s [%s] DEBUG %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
    }

    @Override
    public synchronized void debug(Throwable throwable, String message) {
        System.out.format("%s [%s] DEBUG %s - %s%n", this.getNow(), this.getThread(), this.name, message);
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public synchronized void debug(Throwable throwable, String message, Object ... args) {
        System.out.format("%s [%s] DEBUG %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public synchronized void debug(String message) {
        System.out.format("%s [%s] DEBUG %s - %s%n", this.getNow(), this.getThread(), this.name, message);
    }

    @Override
    public synchronized void trace(String message, Object ... args) {
        System.out.format("%s [%s] TRACE %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
    }

    @Override
    public synchronized void trace(Throwable throwable, String message) {
        System.out.format("%s [%s] TRACE %s - %s%n", this.getNow(), this.getThread(), this.name, message);
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public synchronized void trace(Throwable throwable, String message, Object ... args) {
        System.out.format("%s [%s] TRACE %s - %s%n", this.getNow(), this.getThread(), this.name, ConsoleLogger.format(message, args));
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public synchronized void trace(String message) {
        System.out.format("%s [%s] TRACE %s - %s%n", this.getNow(), this.getThread(), this.name, message);
    }

    private String getThread() {
        return Thread.currentThread().getName();
    }

    private LocalDateTime getNow() {
        return LocalDateTime.now();
    }

    private static String format(String message, Object ... args) {
        if (message == null) {
            return null;
        }
        if (args == null || args.length == 0) {
            return message;
        }
        return MessageFormat.format(message, args);
    }
}

