/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons.web;

import com.github.nosan.embedded.cassandra.commons.function.IOSupplier;
import com.github.nosan.embedded.cassandra.commons.web.HttpRequest;
import com.github.nosan.embedded.cassandra.commons.web.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;

public interface HttpClient {
    default public HttpResponse send(HttpRequest httpRequest) throws IOException {
        return this.send(httpRequest, null);
    }

    public HttpResponse send(HttpRequest var1, IOSupplier<? extends InputStream> var2) throws IOException;

    public static final class BodySuppliers {
        private BodySuppliers() {
        }

        public static IOSupplier<? extends InputStream> ofString(String body) {
            Objects.requireNonNull(body, "Body must not be null");
            return BodySuppliers.ofString(body, Charset.defaultCharset());
        }

        public static IOSupplier<? extends InputStream> ofString(String body, Charset charset) {
            Objects.requireNonNull(body, "Body must not be null");
            Objects.requireNonNull(charset, "Charset must not be null");
            return BodySuppliers.ofBytes(body.getBytes(charset));
        }

        public static IOSupplier<? extends InputStream> ofBytes(byte[] body) {
            Objects.requireNonNull(body, "Body must not be null");
            return () -> new ByteArrayInputStream(body);
        }
    }
}

