/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons.web;

import com.github.nosan.embedded.cassandra.commons.web.HttpHeaders;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;

public class HttpRequest {
    private final URI uri;
    private final String method;
    private final HttpHeaders headers;

    public HttpRequest(URI uri) {
        this(uri, "GET", new HttpHeaders());
    }

    public HttpRequest(URI uri, String method) {
        this(uri, method, new HttpHeaders());
    }

    public HttpRequest(URI uri, String method, HttpHeaders headers) {
        Objects.requireNonNull(uri, "URI must not be null");
        Objects.requireNonNull(method, "HTTP Method must not be null");
        Objects.requireNonNull(headers, "HTTP Headers must not be null");
        this.uri = uri;
        this.method = method.toUpperCase(Locale.ENGLISH);
        this.headers = headers;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "HttpRequest{uri=" + this.uri + ", method='" + this.method + '\'' + '}';
    }
}

