/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.cql;

import com.github.nosan.embedded.cassandra.commons.ClassPathResource;
import com.github.nosan.embedded.cassandra.commons.Resource;
import com.github.nosan.embedded.cassandra.cql.CqlScript;
import com.github.nosan.embedded.cassandra.cql.DefaultCqlDataSet;
import com.github.nosan.embedded.cassandra.cql.ResourceCqlScript;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@FunctionalInterface
public interface CqlDataSet
extends CqlScript {
    public static CqlDataSet ofClassPaths(String ... names) {
        return CqlDataSet.ofClassPaths(Charset.defaultCharset(), names);
    }

    public static CqlDataSet ofClassPaths(Charset charset, String ... names) {
        Objects.requireNonNull(charset, "Charset must not be null");
        Objects.requireNonNull(names, "Classpath resources must not be null");
        return new DefaultCqlDataSet(Arrays.stream(names).map(ClassPathResource::new).map(resource -> new ResourceCqlScript((Resource)resource, charset)).collect(Collectors.toList()));
    }

    public static CqlDataSet ofResources(Resource ... resources) {
        return CqlDataSet.ofResources(Charset.defaultCharset(), resources);
    }

    public static CqlDataSet ofResources(Charset charset, Resource ... resources) {
        Objects.requireNonNull(charset, "Charset must not be null");
        Objects.requireNonNull(resources, "Resources must not be null");
        return new DefaultCqlDataSet(Arrays.stream(resources).map(resource -> new ResourceCqlScript((Resource)resource, charset)).collect(Collectors.toList()));
    }

    public static CqlDataSet ofScripts(CqlScript ... scripts) {
        Objects.requireNonNull(scripts, "Cql Scripts must not be null");
        ArrayList<? extends CqlScript> result = new ArrayList<CqlScript>();
        for (CqlScript script : scripts) {
            if (script instanceof CqlDataSet) {
                result.addAll(((CqlDataSet)script).getScripts());
                continue;
            }
            result.add(script);
        }
        return new DefaultCqlDataSet(result);
    }

    default public void forEachScript(Consumer<? super CqlScript> callback) {
        Objects.requireNonNull(callback, "Callback must not be null");
        this.getScripts().forEach(callback);
    }

    @Override
    default public List<String> getStatements() {
        ArrayList statements = new ArrayList();
        this.forEachScript(script -> statements.addAll(script.getStatements()));
        return Collections.unmodifiableList(statements);
    }

    public List<? extends CqlScript> getScripts();
}

