/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.cql;

import com.github.nosan.embedded.cassandra.commons.Resource;
import com.github.nosan.embedded.cassandra.commons.StreamUtils;
import com.github.nosan.embedded.cassandra.cql.AbstractCqlScript;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Objects;

public class ResourceCqlScript
extends AbstractCqlScript {
    private final Resource resource;
    private final Charset charset;

    public ResourceCqlScript(Resource resource) {
        this(resource, Charset.defaultCharset());
    }

    public ResourceCqlScript(Resource resource, Charset charset) {
        Objects.requireNonNull(resource, "Resource must not be null");
        Objects.requireNonNull(charset, "Charset must not be null");
        this.charset = charset;
        this.resource = resource;
    }

    @Override
    protected String getScript() {
        String string;
        block8: {
            InputStream is = this.resource.getInputStream();
            try {
                string = StreamUtils.toString(is, this.charset);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException("Could not open a stream for " + this.resource, ex);
                }
            }
            is.close();
        }
        return string;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResourceCqlScript that = (ResourceCqlScript)other;
        if (!this.charset.equals(that.charset)) {
            return false;
        }
        return this.resource.equals(that.resource);
    }

    public int hashCode() {
        int result = this.charset.hashCode();
        result = 31 * result + this.resource.hashCode();
        return result;
    }

    public String toString() {
        return "ResourceCqlScript{resource=" + this.resource + ", charset=" + this.charset + '}';
    }
}

