/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.CassandraDatabase;
import com.github.nosan.embedded.cassandra.Process;
import com.github.nosan.embedded.cassandra.Version;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

abstract class AbstractCassandraDatabase
implements CassandraDatabase {
    private final String name;
    private final Version version;
    private final Path configurationFile;
    private final Path workingDirectory;
    private final Map<String, String> environmentVariables;
    private final Map<String, Object> configProperties;
    private final Map<String, String> systemProperties;
    private final Set<String> jvmOptions;
    private volatile Process process;

    AbstractCassandraDatabase(String name, Version version, Path configurationFile, Path workingDirectory, Map<String, String> environmentVariables, Map<String, Object> configProperties, Map<String, String> systemProperties, Set<String> jvmOptions) {
        this.name = name;
        this.version = version;
        this.configurationFile = configurationFile;
        this.workingDirectory = workingDirectory;
        this.environmentVariables = Collections.unmodifiableMap(new LinkedHashMap<String, String>(environmentVariables));
        this.configProperties = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(configProperties));
        this.systemProperties = Collections.unmodifiableMap(new LinkedHashMap<String, String>(systemProperties));
        this.jvmOptions = Collections.unmodifiableSet(new LinkedHashSet<String>(jvmOptions));
    }

    @Override
    public final synchronized void start() throws IOException {
        this.process = this.doStart();
    }

    @Override
    public final synchronized void stop() throws IOException {
        Process process = this.process;
        if (process != null && process.isAlive()) {
            this.doStop(process);
            if (!process.destroy().waitFor(5, TimeUnit.SECONDS) && !process.destroyForcibly().waitFor(3, TimeUnit.SECONDS)) {
                throw new IOException("Unable to stop " + this);
            }
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public final Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    @Override
    public final Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public final Set<String> getJvmOptions() {
        return this.jvmOptions;
    }

    @Override
    public final synchronized CompletableFuture<? extends CassandraDatabase> onExit() {
        return this.process.onExit().thenApply(processHandler -> this);
    }

    @Override
    public final synchronized boolean isAlive() {
        Process process = this.process;
        return process != null && process.isAlive();
    }

    @Override
    public final Version getVersion() {
        return this.version;
    }

    @Override
    public final Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public final Path getConfigurationFile() {
        return this.configurationFile;
    }

    @Override
    public final synchronized Process.Output getStdOut() {
        return this.process.getStdOut();
    }

    @Override
    public final synchronized Process.Output getStdErr() {
        return this.process.getStdErr();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{process=" + this.process + '}';
    }

    protected abstract Process doStart() throws IOException;

    protected abstract void doStop(Process var1) throws IOException;
}

