/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.Cassandra;
import com.github.nosan.embedded.cassandra.CassandraBuilderConfigurator;
import com.github.nosan.embedded.cassandra.DefaultCassandra;
import com.github.nosan.embedded.cassandra.DefaultCassandraDatabaseFactory;
import com.github.nosan.embedded.cassandra.DefaultWorkingDirectoryInitializer;
import com.github.nosan.embedded.cassandra.Version;
import com.github.nosan.embedded.cassandra.WebCassandraDirectoryProvider;
import com.github.nosan.embedded.cassandra.WorkingDirectoryCustomizer;
import com.github.nosan.embedded.cassandra.WorkingDirectoryDestroyer;
import com.github.nosan.embedded.cassandra.WorkingDirectoryInitializer;
import com.github.nosan.embedded.cassandra.commons.Resource;
import com.github.nosan.embedded.cassandra.commons.StringUtils;
import com.github.nosan.embedded.cassandra.commons.function.IOSupplier;
import com.github.nosan.embedded.cassandra.commons.logging.Logger;
import com.github.nosan.embedded.cassandra.commons.web.JdkHttpClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class CassandraBuilder {
    public static final Version DEFAULT_VERSION = Version.parse("4.1.3");
    private static final AtomicInteger CASSANDRA_ID = new AtomicInteger();
    private final Map<String, Object> environmentVariables = new LinkedHashMap<String, Object>();
    private final Map<String, Object> configProperties = new LinkedHashMap<String, Object>();
    private final Map<String, Object> systemProperties = new LinkedHashMap<String, Object>();
    private final Set<String> jvmOptions = new LinkedHashSet<String>();
    private final Set<WorkingDirectoryCustomizer> workingDirectoryCustomizers = new LinkedHashSet<WorkingDirectoryCustomizer>();
    private boolean registerShutdownHook = true;
    private String name;
    private Version version;
    private Duration startupTimeout;
    private Logger logger;
    private IOSupplier<? extends Path> workingDirectorySupplier;
    private WorkingDirectoryDestroyer workingDirectoryDestroyer;
    private WorkingDirectoryInitializer workingDirectoryInitializer;

    public Cassandra build() {
        Logger logger;
        Duration startupTimeout;
        WorkingDirectoryDestroyer workingDirectoryDestroyer;
        Path workingDirectory;
        String name = this.name != null ? this.name : "cassandra-" + CASSANDRA_ID.getAndIncrement();
        Version version = this.version != null ? this.version : DEFAULT_VERSION;
        try {
            IOSupplier<? extends Path> workingDirectorySupplier = this.workingDirectorySupplier;
            if (workingDirectorySupplier != null) {
                workingDirectory = workingDirectorySupplier.get();
                Objects.requireNonNull(workingDirectory, "Working Directory must not be null");
            } else {
                workingDirectory = Files.createTempDirectory("", new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Unable to get a working directory", ex);
        }
        WorkingDirectoryInitializer workingDirectoryInitializer = this.workingDirectoryInitializer;
        if (workingDirectoryInitializer == null) {
            workingDirectoryInitializer = new DefaultWorkingDirectoryInitializer(new WebCassandraDirectoryProvider(new JdkHttpClient(Duration.ofMinutes(1L), Duration.ofMinutes(1L))));
        }
        if ((workingDirectoryDestroyer = this.workingDirectoryDestroyer) == null) {
            workingDirectoryDestroyer = WorkingDirectoryDestroyer.deleteAll();
        }
        if ((startupTimeout = this.startupTimeout) == null) {
            startupTimeout = Duration.ofMinutes(2L);
        }
        if ((logger = this.logger) == null) {
            logger = Logger.get(Cassandra.class);
        }
        LinkedHashMap<String, Object> environmentVariables = new LinkedHashMap<String, Object>(this.environmentVariables);
        environmentVariables.values().removeIf(Objects::isNull);
        LinkedHashMap<String, Object> systemProperties = new LinkedHashMap<String, Object>(this.systemProperties);
        systemProperties.values().removeIf(Objects::isNull);
        LinkedHashSet<String> jvmOptions = new LinkedHashSet<String>(this.jvmOptions);
        jvmOptions.removeIf(Objects::isNull);
        LinkedHashSet<WorkingDirectoryCustomizer> workingDirectoryCustomizers = new LinkedHashSet<WorkingDirectoryCustomizer>(this.workingDirectoryCustomizers);
        workingDirectoryCustomizers.removeIf(Objects::isNull);
        LinkedHashMap<String, Object> configProperties = new LinkedHashMap<String, Object>(this.configProperties);
        DefaultCassandraDatabaseFactory databaseFactory = new DefaultCassandraDatabaseFactory(name, version, environmentVariables, configProperties, systemProperties, jvmOptions);
        return new DefaultCassandra(name, version, workingDirectory.normalize().toAbsolutePath(), this.registerShutdownHook, workingDirectoryInitializer, workingDirectoryDestroyer, startupTimeout, workingDirectoryCustomizers, databaseFactory, logger);
    }

    public CassandraBuilder name(String name) {
        Objects.requireNonNull(name, "Name must not be null");
        if (!StringUtils.hasText(name)) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CassandraBuilder version(String version) {
        Objects.requireNonNull(version, "Version must not be null");
        return this.version(Version.parse(version));
    }

    public CassandraBuilder version(Version version) {
        Objects.requireNonNull(version, "Version must not be null");
        this.version = version;
        return this;
    }

    public Version getVersion() {
        Version version = this.version;
        return version != null ? version : DEFAULT_VERSION;
    }

    public CassandraBuilder logger(Logger logger) {
        Objects.requireNonNull(logger, "Logger must not be null");
        this.logger = logger;
        return this;
    }

    public CassandraBuilder registerShutdownHook(boolean registerShutdownHook) {
        this.registerShutdownHook = registerShutdownHook;
        return this;
    }

    public CassandraBuilder startupTimeout(Duration startupTimeout) {
        Objects.requireNonNull(startupTimeout, "Startup Timeout must not be null");
        if (startupTimeout.isZero() || startupTimeout.isNegative()) {
            throw new IllegalArgumentException("Startup Timeout must be positive");
        }
        this.startupTimeout = startupTimeout;
        return this;
    }

    public CassandraBuilder configFile(Resource configFile) {
        return this.addSystemProperty("cassandra.config", configFile);
    }

    public CassandraBuilder workingDirectory(IOSupplier<? extends Path> workingDirectorySupplier) {
        Objects.requireNonNull(workingDirectorySupplier, "Working Directory Supplier must not be null");
        this.workingDirectorySupplier = workingDirectorySupplier;
        return this;
    }

    public CassandraBuilder workingDirectoryInitializer(WorkingDirectoryInitializer workingDirectoryInitializer) {
        Objects.requireNonNull(workingDirectoryInitializer, "Working Directory Initializer must not be null");
        this.workingDirectoryInitializer = workingDirectoryInitializer;
        return this;
    }

    public CassandraBuilder workingDirectoryDestroyer(WorkingDirectoryDestroyer workingDirectoryDestroyer) {
        Objects.requireNonNull(workingDirectoryDestroyer, "Working Directory Destroyer must not be null");
        this.workingDirectoryDestroyer = workingDirectoryDestroyer;
        return this;
    }

    public CassandraBuilder workingDirectoryCustomizers(WorkingDirectoryCustomizer ... workingDirectoryCustomizers) {
        Objects.requireNonNull(workingDirectoryCustomizers, "Working Directory Customizers must not be null");
        return this.workingDirectoryCustomizers(Arrays.asList(workingDirectoryCustomizers));
    }

    public CassandraBuilder workingDirectoryCustomizers(Collection<? extends WorkingDirectoryCustomizer> workingDirectoryCustomizers) {
        Objects.requireNonNull(workingDirectoryCustomizers, "Working Directory Customizers must not be null");
        this.workingDirectoryCustomizers.clear();
        this.workingDirectoryCustomizers.addAll(CassandraBuilder.deepCopy(workingDirectoryCustomizers));
        return this;
    }

    public CassandraBuilder addWorkingDirectoryCustomizers(WorkingDirectoryCustomizer ... workingDirectoryCustomizers) {
        Objects.requireNonNull(workingDirectoryCustomizers, "Working Directory Customizers must not be null");
        return this.addWorkingDirectoryCustomizers(Arrays.asList(workingDirectoryCustomizers));
    }

    public CassandraBuilder addWorkingDirectoryCustomizers(Collection<? extends WorkingDirectoryCustomizer> workingDirectoryCustomizers) {
        Objects.requireNonNull(workingDirectoryCustomizers, "Working Directory Customizers must not be null");
        this.workingDirectoryCustomizers.addAll(CassandraBuilder.deepCopy(workingDirectoryCustomizers));
        return this;
    }

    public CassandraBuilder environmentVariables(Map<String, ?> environmentVariables) {
        Objects.requireNonNull(environmentVariables, "Environment Variables must not be null");
        this.environmentVariables.clear();
        this.environmentVariables.putAll(CassandraBuilder.deepCopy(environmentVariables));
        return this;
    }

    public CassandraBuilder addEnvironmentVariable(String name, Object value) {
        return this.addEnvironmentVariables(Collections.singletonMap(name, value));
    }

    public CassandraBuilder addEnvironmentVariables(Map<String, ?> environmentVariables) {
        Objects.requireNonNull(environmentVariables, "Environment Variables must not be null");
        this.environmentVariables.putAll(CassandraBuilder.deepCopy(environmentVariables));
        return this;
    }

    public CassandraBuilder systemProperties(Map<String, ?> systemProperties) {
        Objects.requireNonNull(systemProperties, "System Properties must not be null");
        this.systemProperties.clear();
        this.systemProperties.putAll(CassandraBuilder.deepCopy(systemProperties));
        return this;
    }

    public CassandraBuilder addSystemProperty(String name, Object value) {
        return this.addSystemProperties(Collections.singletonMap(name, value));
    }

    public CassandraBuilder addSystemProperties(Map<String, ?> systemProperties) {
        Objects.requireNonNull(systemProperties, "System Properties must not be null");
        this.systemProperties.putAll(CassandraBuilder.deepCopy(systemProperties));
        return this;
    }

    public CassandraBuilder jvmOptions(String ... jvmOptions) {
        Objects.requireNonNull(jvmOptions, "JVM Options must not be null");
        return this.jvmOptions(Arrays.asList(jvmOptions));
    }

    public CassandraBuilder jvmOptions(Collection<String> jvmOptions) {
        Objects.requireNonNull(jvmOptions, "JVM Options must not be null");
        this.jvmOptions.clear();
        this.jvmOptions.addAll(CassandraBuilder.deepCopy(jvmOptions));
        return this;
    }

    public CassandraBuilder addJvmOptions(String ... jvmOptions) {
        Objects.requireNonNull(jvmOptions, "JVM Options must not be null");
        return this.addJvmOptions(Arrays.asList(jvmOptions));
    }

    public CassandraBuilder addJvmOptions(Collection<String> jvmOptions) {
        Objects.requireNonNull(jvmOptions, "JVM Options must not be null");
        this.jvmOptions.addAll(CassandraBuilder.deepCopy(jvmOptions));
        return this;
    }

    public CassandraBuilder configProperties(Map<String, ?> configProperties) {
        Objects.requireNonNull(configProperties, "Config Properties must not be null");
        this.configProperties.clear();
        this.configProperties.putAll(CassandraBuilder.deepCopy(configProperties));
        return this;
    }

    public CassandraBuilder addConfigProperty(String name, Object value) {
        return this.addConfigProperties(Collections.singletonMap(name, value));
    }

    public CassandraBuilder addConfigProperties(Map<String, ?> configProperties) {
        Objects.requireNonNull(configProperties, "Config Properties must not be null");
        this.configProperties.putAll(CassandraBuilder.deepCopy(configProperties));
        return this;
    }

    public CassandraBuilder addWorkingDirectoryResource(Resource resource, String path) {
        return this.addWorkingDirectoryCustomizers(WorkingDirectoryCustomizer.addResource(resource, path));
    }

    public CassandraBuilder configure(CassandraBuilderConfigurator configurator) {
        Objects.requireNonNull(configurator, "Cassandra Builder Configurator must not be null");
        configurator.configure(this);
        return this;
    }

    private static <T> T deepCopy(T object) {
        if (object instanceof Map) {
            LinkedHashMap result = new LinkedHashMap();
            ((Map)object).forEach((name, value) -> {
                if (StringUtils.hasText(Objects.toString(name, null))) {
                    result.put(name, CassandraBuilder.deepCopy(value));
                }
            });
            return (T)Collections.unmodifiableMap(result);
        }
        if (object instanceof Collection) {
            ArrayList result = new ArrayList();
            ((Iterable)object).forEach(each -> result.add(CassandraBuilder.deepCopy(each)));
            return (T)Collections.unmodifiableList(result);
        }
        if (object instanceof Object[]) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object each2 : (Object[])object) {
                result.add(CassandraBuilder.deepCopy(each2));
            }
            return (T)Collections.unmodifiableList(result);
        }
        return object;
    }
}

