/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.CassandraDatabase;
import com.github.nosan.embedded.cassandra.CassandraDatabaseFactory;
import com.github.nosan.embedded.cassandra.UnixCassandraDatabase;
import com.github.nosan.embedded.cassandra.Version;
import com.github.nosan.embedded.cassandra.WindowsCassandraDatabase;
import com.github.nosan.embedded.cassandra.commons.FileSystemResource;
import com.github.nosan.embedded.cassandra.commons.Resource;
import com.github.nosan.embedded.cassandra.commons.StringUtils;
import com.github.nosan.embedded.cassandra.commons.UrlResource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

class DefaultCassandraDatabaseFactory
implements CassandraDatabaseFactory {
    private final String name;
    private final Version version;
    private final Map<String, Object> environmentVariables;
    private final Map<String, Object> configProperties;
    private final Map<String, Object> systemProperties;
    private final Set<String> jvmOptions;

    DefaultCassandraDatabaseFactory(String name, Version version, Map<String, Object> environmentVariables, Map<String, Object> configProperties, Map<String, Object> systemProperties, Set<String> jvmOptions) {
        this.name = name;
        this.version = version;
        this.environmentVariables = Collections.unmodifiableMap(environmentVariables);
        this.configProperties = Collections.unmodifiableMap(configProperties);
        this.systemProperties = Collections.unmodifiableMap(systemProperties);
        this.jvmOptions = Collections.unmodifiableSet(jvmOptions);
    }

    @Override
    public CassandraDatabase create(Path workingDirectory) throws Exception {
        Version version = this.version;
        Resource configFile = DefaultCassandraDatabaseFactory.getConfigFile(workingDirectory, this.systemProperties.get("cassandra.config"));
        LinkedHashMap<String, String> systemProperties = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.systemProperties.entrySet()) {
            systemProperties.put(entry.getKey(), Objects.toString(DefaultCassandraDatabaseFactory.getValue(entry.getValue()), ""));
        }
        DefaultCassandraDatabaseFactory.configureSystemProperties(systemProperties);
        Map<String, Object> configProperties = DefaultCassandraDatabaseFactory.loadProperties(configFile);
        DefaultCassandraDatabaseFactory.setProperties(null, this.configProperties, configProperties);
        DefaultCassandraDatabaseFactory.configureConfigProperties(configProperties);
        if (version.getMajor() >= 4) {
            DefaultCassandraDatabaseFactory.configureSeeds(configProperties, systemProperties);
        }
        Path newConfigFile = Files.createTempFile(workingDirectory.resolve("conf"), "", "-" + configFile.getFileName().orElse("cassandra.yaml"), new FileAttribute[0]);
        DefaultCassandraDatabaseFactory.writeProperties(configProperties, newConfigFile);
        systemProperties.put("cassandra.config", newConfigFile.toUri().toString());
        ArrayList<String> jvmExtraOpts = new ArrayList<String>(this.jvmOptions);
        systemProperties.forEach((name, value) -> {
            if (value.isEmpty()) {
                jvmExtraOpts.add("-D" + name);
            } else {
                jvmExtraOpts.add("-D" + name + "=" + value);
            }
        });
        LinkedHashMap<String, String> environmentVariables = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.environmentVariables.entrySet()) {
            environmentVariables.put(entry.getKey(), Objects.toString(entry.getValue(), ""));
        }
        environmentVariables.merge("JVM_EXTRA_OPTS", String.join((CharSequence)" ", jvmExtraOpts), (s1, s2) -> s1 + " " + s2);
        if (!environmentVariables.containsKey("JAVA_HOME")) {
            Optional.ofNullable(System.getProperty("java.home")).filter(StringUtils::hasText).ifPresent(path -> environmentVariables.put("JAVA_HOME", (String)path));
        }
        Files.createDirectories(workingDirectory.resolve("logs"), new FileAttribute[0]);
        Files.createDirectories(workingDirectory.resolve("data"), new FileAttribute[0]);
        if (DefaultCassandraDatabaseFactory.isWindows()) {
            Path pidFile = Files.createTempFile(workingDirectory.resolve("bin"), "", "-cassandra.pid", new FileAttribute[0]);
            return new WindowsCassandraDatabase(this.name, version, newConfigFile, workingDirectory, environmentVariables, configProperties, systemProperties, this.jvmOptions, pidFile);
        }
        return new UnixCassandraDatabase(this.name, version, newConfigFile, workingDirectory, environmentVariables, configProperties, systemProperties, this.jvmOptions);
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase(Locale.ENGLISH).startsWith("windows");
    }

    private static void writeProperties(Map<String, Object> properties, Path configFile) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            new Yaml(dumperOptions).dump(properties, (Writer)writer);
        }
    }

    private static Map<String, Object> loadProperties(Resource file) throws IOException {
        try (InputStream is = file.getInputStream();){
            Map properties = (Map)new Yaml().loadAs(is, Map.class);
            if (properties == null) {
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(0);
                return linkedHashMap;
            }
            Map map = properties;
            return map;
        }
    }

    private static Resource getConfigFile(Path workingDirectory, Object url) throws MalformedURLException {
        if (url instanceof Resource) {
            return (Resource)url;
        }
        if (url instanceof Path) {
            return new FileSystemResource(((Path)url).toAbsolutePath());
        }
        if (url instanceof File) {
            return new FileSystemResource((File)url);
        }
        if (url instanceof URL) {
            return new UrlResource((URL)url);
        }
        if (url instanceof URI) {
            return new UrlResource(((URI)url).toURL());
        }
        if (url != null) {
            return new UrlResource(new URL(url.toString()));
        }
        return new FileSystemResource(workingDirectory.resolve("conf/cassandra.yaml"));
    }

    private static void configureSystemProperties(Map<String, String> systemProperties) throws IOException {
        DefaultCassandraDatabaseFactory.setPort("cassandra.native_transport_port", systemProperties);
        DefaultCassandraDatabaseFactory.setPort("cassandra.storage_port", systemProperties);
        DefaultCassandraDatabaseFactory.setPort("cassandra.ssl_storage_port", systemProperties);
        DefaultCassandraDatabaseFactory.setPort("cassandra.rpc_port", systemProperties);
        DefaultCassandraDatabaseFactory.setPort("cassandra.jmx.remote.port", systemProperties);
        DefaultCassandraDatabaseFactory.setPort("cassandra.jmx.local.port", systemProperties);
        DefaultCassandraDatabaseFactory.setPort("com.sun.management.jmxremote.rmi.port", systemProperties);
    }

    private static void configureConfigProperties(Map<String, Object> configProperties) throws IOException {
        DefaultCassandraDatabaseFactory.setPort("native_transport_port", configProperties);
        DefaultCassandraDatabaseFactory.setPort("storage_port", configProperties);
        DefaultCassandraDatabaseFactory.setPort("ssl_storage_port", configProperties);
        DefaultCassandraDatabaseFactory.setPort("rpc_port", configProperties);
        DefaultCassandraDatabaseFactory.setPort("native_transport_port_ssl", configProperties);
    }

    private static void setPort(String name, Map<String, ? super String> target) throws IOException {
        if (Objects.toString(target.get(name), "").equals("0")) {
            try (ServerSocket ss = new ServerSocket(0);){
                target.put(name, Integer.toString(ss.getLocalPort()));
            }
        }
    }

    private static void setProperties(String parentName, Map<String, Object> source, Map<String, Object> target) throws IOException {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String fullName = parentName != null ? parentName + "." + entry.getKey() : entry.getKey();
            DefaultCassandraDatabaseFactory.setProperty(fullName, parentName, entry.getKey(), DefaultCassandraDatabaseFactory.getValue(entry.getValue()), target);
        }
    }

    private static void setProperty(String fullName, String parentName, String name, Object value, Map<String, Object> target) throws IOException {
        int index = -1;
        while ((index = name.indexOf(46, index + 1)) != -1) {
            int backslashes = 0;
            for (int i = index - 1; i >= 0 && name.charAt(i) == '\\'; --i) {
                ++backslashes;
            }
            String n = name.substring(index - backslashes, index).replace("\\\\", "\\");
            name = name.substring(0, index - backslashes) + n + name.substring(index);
            index -= backslashes / 2;
            if (backslashes % 2 == 0) break;
            name = name.substring(0, index - 1) + name.substring(index);
            --index;
        }
        if (index != -1) {
            String rootName = name.substring(0, index);
            if (rootName.isEmpty()) {
                throw new IllegalArgumentException(String.format("Config property: '%s' is invalid", name));
            }
            if (target.get(rootName) instanceof Map) {
                Map rootValue = (Map)target.get(rootName);
                target.put(rootName, rootValue);
                DefaultCassandraDatabaseFactory.setProperty(fullName, rootName, name.substring(index + 1), value, rootValue);
            } else if (target.get(rootName) == null) {
                LinkedHashMap<String, Object> rootValueMap = new LinkedHashMap<String, Object>();
                target.put(rootName, rootValueMap);
                DefaultCassandraDatabaseFactory.setProperty(fullName, rootName, name.substring(index + 1), value, rootValueMap);
            } else {
                throw new IllegalArgumentException(String.format("Config property: '%s: %s' cannot be set. Property: '%s.%s' has a type: '%s' and it cannot have nested properties.", fullName, value, parentName, rootName, target.get(rootName).getClass().getCanonicalName()));
            }
            return;
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Config property must not be empty");
        }
        if (target.get(name) instanceof Map && value instanceof Map) {
            Map rootValue = (Map)target.get(name);
            target.put(name, rootValue);
            DefaultCassandraDatabaseFactory.setProperties(name, (Map)value, rootValue);
        } else {
            target.put(name, value);
        }
    }

    private static void configureSeeds(Map<String, Object> configProperties, Map<String, String> systemProperties) {
        String storagePort = Optional.ofNullable(systemProperties.get("cassandra.storage_port")).orElseGet(() -> Objects.toString(configProperties.get("storage_port"), "7000"));
        for (Map<String, Object> seedProvider : DefaultCassandraDatabaseFactory.getSeedProvider(configProperties)) {
            for (Map<String, Object> parameter : DefaultCassandraDatabaseFactory.getParameters(seedProvider)) {
                List<String> seeds = DefaultCassandraDatabaseFactory.getSeeds(parameter);
                if (seeds.isEmpty()) continue;
                seeds.replaceAll(seed -> {
                    int index = seed.indexOf(58);
                    if (index != -1 && seed.indexOf(58, index + 1) != -1) {
                        return seed.replaceAll("]:0\\b(\\s*)$", String.format("]:%s$1", storagePort));
                    }
                    if (index != -1) {
                        return seed.replaceAll(":0\\b(\\s*)$", String.format(":%s$1", storagePort));
                    }
                    return seed;
                });
                parameter.put("seeds", String.join((CharSequence)",", seeds));
            }
        }
    }

    private static List<Map<String, Object>> getSeedProvider(Map<String, Object> configProperties) {
        List seedProvider = (List)configProperties.get("seed_provider");
        if (seedProvider == null) {
            return Collections.emptyList();
        }
        return seedProvider;
    }

    private static List<Map<String, Object>> getParameters(Map<String, Object> seedProvider) {
        List parameters = (List)seedProvider.get("parameters");
        if (parameters == null) {
            return Collections.emptyList();
        }
        return parameters;
    }

    private static List<String> getSeeds(Map<String, Object> parameter) {
        return Optional.ofNullable(parameter).map(p -> p.get("seeds")).map(String::valueOf).map(seeds -> Arrays.stream(seeds.split(",")).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static Object getValue(Object object) throws IOException {
        if (object instanceof Path) {
            return ((Path)object).normalize().toAbsolutePath().toString();
        }
        if (object instanceof File) {
            return ((File)object).toPath().normalize().toAbsolutePath().toString();
        }
        if (object instanceof URI) {
            return object.toString();
        }
        if (object instanceof URL) {
            return object.toString();
        }
        if (object instanceof Resource) {
            try {
                return DefaultCassandraDatabaseFactory.getValue(Paths.get(((Resource)object).toURI()));
            }
            catch (Exception exception) {
                try {
                    return DefaultCassandraDatabaseFactory.getValue(((Resource)object).toURI());
                }
                catch (IOException iOException) {
                    return DefaultCassandraDatabaseFactory.getValue(((Resource)object).toURL());
                }
            }
        }
        if (object instanceof InetAddress) {
            return ((InetAddress)object).getHostName();
        }
        if (object instanceof Map) {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                result.put(entry.getKey(), DefaultCassandraDatabaseFactory.getValue(entry.getValue()));
            }
            return result;
        }
        if (object instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : (Collection)object) {
                result.add(DefaultCassandraDatabaseFactory.getValue(o));
            }
            return result;
        }
        if (object instanceof Object[]) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : (Object[])object) {
                result.add(DefaultCassandraDatabaseFactory.getValue(o));
            }
            return result;
        }
        return object;
    }
}

