/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.CassandraDatabase;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NativeTransportParser
implements Consumer<String>,
Closeable {
    private static final Pattern TRANSPORT_START_PATTERN = Pattern.compile("Starting listening for CQL clients on .*/(.+):(\\d+)", 2);
    private static final Pattern TRANSPORT_NOT_START = Pattern.compile("Not starting native transport as requested", 2);
    private static final Pattern TRANSPORTS_NOT_START = Pattern.compile("Not starting client transports", 2);
    private static final Pattern FAILED_TO_BIND = Pattern.compile("Failed to bind port (\\d+) on .+", 2);
    private static final String ENCRYPTED = "(encrypted)";
    private final CassandraDatabase database;
    private volatile InetAddress address;
    private volatile Integer sslPort;
    private volatile Integer port;
    private volatile boolean disabled;
    private volatile boolean failed;

    NativeTransportParser(CassandraDatabase database) {
        this.database = database;
        this.disabled = database.getVersion().getMajor() < 2;
        database.getStdOut().attach(this);
        database.getStdErr().attach(this);
    }

    @Override
    public void accept(String line) {
        Matcher matcher = TRANSPORT_START_PATTERN.matcher(line);
        if (matcher.find()) {
            this.address = NativeTransportParser.getAddress(matcher.group(1));
            if (line.contains(ENCRYPTED) && NativeTransportParser.getSslPort(this.database) != null) {
                this.sslPort = Integer.parseInt(matcher.group(2));
            } else {
                this.port = Integer.parseInt(matcher.group(2));
            }
        } else if (TRANSPORT_NOT_START.matcher(line).find()) {
            this.disabled = true;
        } else if (TRANSPORTS_NOT_START.matcher(line).find()) {
            this.disabled = true;
        } else if (this.address != null && FAILED_TO_BIND.matcher(line).find()) {
            this.failed = true;
        }
    }

    @Override
    public void close() {
        this.database.getStdOut().detach(this);
        this.database.getStdErr().detach(this);
    }

    boolean isFailed() {
        return this.failed;
    }

    boolean isParsed() {
        if (this.disabled) {
            return true;
        }
        return this.isStarted();
    }

    boolean isStarted() {
        if (NativeTransportParser.getSslPort(this.database) != null && this.sslPort == null) {
            return false;
        }
        return this.address != null;
    }

    InetAddress getAddress() {
        return this.address;
    }

    Integer getPort() {
        return this.port;
    }

    Integer getSslPort() {
        return this.sslPort;
    }

    private static InetAddress getAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException(String.format("Could not parse an address: '%s'", address), ex);
        }
    }

    private static Integer getSslPort(CassandraDatabase database) {
        Object value = database.getConfigProperties().get("native_transport_port_ssl");
        return value != null ? Integer.valueOf(Integer.parseInt(value.toString())) : null;
    }
}

