/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.CassandraDatabase;
import com.github.nosan.embedded.cassandra.Version;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;

class StartupParser
implements Consumer<String>,
Closeable {
    private static final Pattern STARTUP_COMPLETE = Pattern.compile("Startup complete$", 2);
    private static final Set<String> UNSUPPORTED_VERSIONS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("4.0-alpha1", "4.0-alpha2", "4.0-alpha3", "4.0-alpha4", "4.0-beta1", "4.0-beta2")));
    private final CassandraDatabase database;
    private volatile boolean complete;

    StartupParser(CassandraDatabase database) {
        this.database = database;
        this.complete = !StartupParser.supports(database.getVersion());
        database.getStdOut().attach(this);
    }

    @Override
    public void accept(String line) {
        if (STARTUP_COMPLETE.matcher(line).find()) {
            this.complete = true;
        }
    }

    @Override
    public void close() {
        this.database.getStdOut().detach(this);
    }

    boolean isComplete() {
        return this.complete;
    }

    private static boolean supports(Version version) {
        if (version.getMajor() < 4) {
            return false;
        }
        return !UNSUPPORTED_VERSIONS.contains(version.toString());
    }
}

