/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([0-9]+)\\.([0-9]+)(\\.([0-9]+))?(-([^\\\\/]+))?$");
    private final String version;
    private final int major;
    private final int minor;
    private final Integer patch;
    private final String label;

    private Version(String version, int major, int minor, Integer patch, String label) {
        this.version = version;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.label = label;
    }

    public static Version parse(String version) throws IllegalArgumentException {
        if (version == null || version.trim().isEmpty()) {
            throw new IllegalArgumentException("Version must not be null or blank");
        }
        Matcher matcher = VERSION_PATTERN.matcher(version.trim());
        if (matcher.find()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            Integer patch = matcher.group(4) != null ? Integer.valueOf(Integer.parseInt(matcher.group(4))) : null;
            String label = matcher.group(6);
            return new Version(version.trim(), major, minor, patch, label);
        }
        throw new IllegalArgumentException("Version '" + version + "' is invalid");
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public OptionalInt getPatch() {
        Integer patch = this.patch;
        return patch != null ? OptionalInt.of(patch) : OptionalInt.empty();
    }

    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Version v = (Version)other;
        return this.version.equals(v.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    @Override
    public int compareTo(Version other) {
        int majorCmp = Integer.compare(this.getMajor(), other.getMajor());
        if (majorCmp == 0) {
            int minCmp = Integer.compare(this.getMinor(), other.getMinor());
            if (minCmp == 0) {
                int patchCmp = Integer.compare(this.getPatch().orElse(0), other.getPatch().orElse(0));
                if (patchCmp == 0) {
                    if (this.label == null && other.label == null) {
                        return 0;
                    }
                    if (this.label == null) {
                        return 1;
                    }
                    if (other.label == null) {
                        return -1;
                    }
                    return Math.max(Math.min(this.label.compareTo(other.label), 1), -1);
                }
                return patchCmp;
            }
            return minCmp;
        }
        return majorCmp;
    }

    public String toString() {
        return this.version;
    }
}

