/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.AbstractCassandraDatabase;
import com.github.nosan.embedded.cassandra.DefaultProcess;
import com.github.nosan.embedded.cassandra.Process;
import com.github.nosan.embedded.cassandra.Version;
import com.github.nosan.embedded.cassandra.commons.logging.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class WindowsCassandraDatabase
extends AbstractCassandraDatabase {
    private static final Logger LOGGER = Logger.get(WindowsCassandraDatabase.class);
    private final Path pidFile;

    WindowsCassandraDatabase(String name, Version version, Path configurationFile, Path workingDirectory, Map<String, String> environmentVariables, Map<String, Object> configProperties, Map<String, String> systemProperties, Set<String> jvmOptions, Path pidFile) {
        super(name, version, configurationFile, workingDirectory, environmentVariables, configProperties, systemProperties, jvmOptions);
        this.pidFile = pidFile;
    }

    @Override
    protected Process doStart() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(this.getWorkingDirectory().toFile());
        processBuilder.environment().putAll(this.getEnvironmentVariables());
        return this.startServer(processBuilder);
    }

    @Override
    protected void doStop(Process process) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(this.getWorkingDirectory().toFile());
        processBuilder.environment().putAll(this.getEnvironmentVariables());
        if (this.hasStopFiles() && this.stopServer(processBuilder, false) == 0 && process.waitFor(10, TimeUnit.SECONDS)) {
            return;
        }
        long pid = process.getPid();
        if (pid > 0L && this.taskKill(processBuilder, pid, false) == 0 && process.waitFor(10, TimeUnit.SECONDS)) {
            return;
        }
        if (this.hasStopFiles() && this.stopServer(processBuilder, true) == 0 && process.waitFor(10, TimeUnit.SECONDS)) {
            return;
        }
        if (pid > 0L && this.taskKill(processBuilder, pid, true) == 0 && process.waitFor(10, TimeUnit.SECONDS)) {
            return;
        }
        process.destroy();
    }

    Process start(String name, ProcessBuilder processBuilder) throws IOException {
        LOGGER.info("[{0}] {1}", this.getName(), String.join((CharSequence)" ", processBuilder.command()));
        return new DefaultProcess(name, processBuilder.start());
    }

    int exec(String name, ProcessBuilder processBuilder) throws IOException {
        Process process = this.start(name, processBuilder);
        process.getStdOut().attach(LOGGER::info);
        process.getStdErr().attach(LOGGER::error);
        return process.waitFor();
    }

    private Process startServer(ProcessBuilder processBuilder) throws IOException {
        try {
            return this.startServerPowershell(processBuilder);
        }
        catch (IOException powershell) {
            try {
                return this.startServerBat(processBuilder);
            }
            catch (IOException bat) {
                powershell.addSuppressed(bat);
                throw powershell;
            }
        }
    }

    private Process startServerPowershell(ProcessBuilder processBuilder) throws IOException {
        Path executable = this.getWorkingDirectory().resolve("bin/cassandra.ps1");
        WindowsCassandraDatabase.assertFileExists(executable);
        ArrayList<String> command = new ArrayList<String>();
        command.add("powershell");
        command.add("-ExecutionPolicy");
        command.add("Unrestricted");
        command.add(executable.toString());
        command.add("-p");
        command.add(this.pidFile.toString());
        if (this.getVersion().compareTo(Version.parse("2.2")) >= 0) {
            command.add("-a");
        }
        command.add("-f");
        processBuilder.command(command);
        return this.start(this.getName() + ":bin/cassandra.ps1", processBuilder);
    }

    private Process startServerBat(ProcessBuilder processBuilder) throws IOException {
        Path executable = this.getWorkingDirectory().resolve("bin/cassandra.bat");
        WindowsCassandraDatabase.assertFileExists(executable);
        ArrayList<String> command = new ArrayList<String>();
        command.add(executable.toString());
        command.add("-p");
        command.add(this.pidFile.toString());
        if (this.getVersion().compareTo(Version.parse("2.2")) >= 0) {
            command.add("-a");
        }
        command.add("-f");
        processBuilder.command(command);
        return this.start(this.getName() + ":bin/cassandra.bat", processBuilder);
    }

    private int stopServer(ProcessBuilder processBuilder, boolean force) throws IOException {
        try {
            return this.stopServerPowershell(processBuilder, force);
        }
        catch (IOException powershell) {
            try {
                return this.stopServerBat(processBuilder, force);
            }
            catch (IOException bat) {
                powershell.addSuppressed(bat);
                throw powershell;
            }
        }
    }

    private int stopServerBat(ProcessBuilder processBuilder, boolean force) throws IOException {
        Path executable = this.getWorkingDirectory().resolve("bin/stop-server.bat");
        WindowsCassandraDatabase.assertFileExists(executable);
        ArrayList<String> command = new ArrayList<String>();
        command.add(executable.toString());
        command.add("-p");
        command.add(this.pidFile.toString());
        if (force) {
            command.add("-f");
        }
        processBuilder.command(command);
        return this.exec(this.getName() + ":bin/stop-server.bat", processBuilder);
    }

    private int stopServerPowershell(ProcessBuilder processBuilder, boolean force) throws IOException {
        Path executable = this.getWorkingDirectory().resolve("bin/stop-server.ps1");
        WindowsCassandraDatabase.assertFileExists(executable);
        ArrayList<String> command = new ArrayList<String>();
        command.add("powershell");
        command.add("-ExecutionPolicy");
        command.add("Unrestricted");
        command.add(executable.toString());
        command.add("-p");
        command.add(this.pidFile.toString());
        if (force) {
            command.add("-f");
        }
        processBuilder.command(command);
        return this.exec(this.getName() + ":bin/stop-server.ps1", processBuilder);
    }

    private int taskKill(ProcessBuilder processBuilder, long pid, boolean forceful) throws IOException {
        String name = this.getName() + ":taskkill";
        ArrayList<String> command = new ArrayList<String>();
        command.add("taskkill");
        command.add("/T");
        if (forceful) {
            command.add("/F");
        }
        command.add("/PID");
        command.add(Long.toString(pid));
        processBuilder.command(command);
        return this.exec(name, processBuilder);
    }

    private boolean hasStopFiles() {
        Path powershell = this.getWorkingDirectory().resolve("bin/stop-server.ps1");
        Path bat = this.getWorkingDirectory().resolve("bin/stop-server.bat");
        return Files.exists(powershell, new LinkOption[0]) || Files.exists(bat, new LinkOption[0]);
    }

    private static void assertFileExists(Path executable) throws FileNotFoundException {
        if (!Files.exists(executable, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("%s does not exist", executable));
        }
    }
}

