/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra;

import com.github.nosan.embedded.cassandra.Version;
import com.github.nosan.embedded.cassandra.commons.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

@FunctionalInterface
public interface WorkingDirectoryDestroyer {
    public static WorkingDirectoryDestroyer deleteAll() {
        return (workingDirectory, version) -> FileUtils.delete(workingDirectory);
    }

    public static WorkingDirectoryDestroyer deleteOnly(String ... paths) {
        Objects.requireNonNull(paths, "Paths must not be null");
        for (String path : paths) {
            Objects.requireNonNull(path, "Path must not be null");
        }
        return (workingDirectory, version) -> {
            Objects.requireNonNull(workingDirectory, "Working Directory must not be null");
            Objects.requireNonNull(version, "Version must not be null");
            for (String path : paths) {
                Path normalizedPath = workingDirectory.resolve(path).normalize();
                if (!normalizedPath.startsWith(workingDirectory)) {
                    throw new IllegalArgumentException("Path: '" + path + "' is out of a directory: '" + workingDirectory + "'");
                }
                FileUtils.delete(normalizedPath);
            }
        };
    }

    public static WorkingDirectoryDestroyer doNothing() {
        return (workingDirectory, version) -> {};
    }

    public void destroy(Path var1, Version var2) throws IOException;
}

