/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons;

import com.github.nosan.embedded.cassandra.commons.Resource;
import com.github.nosan.embedded.cassandra.commons.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class FileSystemResource
implements Resource {
    private final Path file;

    public FileSystemResource(Path file) {
        Objects.requireNonNull(file, "Path must not be null");
        this.file = file;
    }

    public FileSystemResource(File file) {
        Objects.requireNonNull(file, "File must not be null");
        this.file = file.toPath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.file, new OpenOption[0]);
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.file.toUri().toURL();
    }

    @Override
    public URI toURI() {
        return this.file.toUri();
    }

    @Override
    public Optional<String> getFileName() {
        return Optional.ofNullable(this.file.getFileName()).map(Object::toString).filter(StringUtils::hasText);
    }

    @Override
    public boolean exists() {
        return Files.exists(this.file, new LinkOption[0]);
    }

    @Override
    public boolean isWritable() {
        return Files.isWritable(this.file) && !Files.isDirectory(this.file, new LinkOption[0]);
    }

    @Override
    public boolean isReadable() {
        return Files.isReadable(this.file) && !Files.isDirectory(this.file, new LinkOption[0]);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileSystemResource that = (FileSystemResource)other;
        return this.file.equals(that.file);
    }

    public Path getFile() {
        return this.file;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return "FileSystemResource{file=" + this.file + '}';
    }
}

