/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;

public interface Resource {
    public Optional<String> getFileName();

    public boolean exists();

    public boolean isWritable();

    public boolean isReadable();

    public InputStream getInputStream() throws IOException;

    public OutputStream getOutputStream() throws IOException;

    public URL toURL() throws IOException;

    default public URI toURI() throws IOException {
        URL url = this.toURL();
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException("URL '" + url + "' is not formatted strictly according to RFC2396 and cannot be converted to a URI", ex);
        }
    }
}

