/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;

public final class StreamUtils {
    private static final int BUFFER_SIZE = 8192;

    private StreamUtils() {
    }

    public static String toString(InputStream inputStream, Charset charset) throws IOException {
        int read;
        Objects.requireNonNull(inputStream, "InputStream must not be null");
        Objects.requireNonNull(charset, "Charset must not be null");
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        char[] buffer = new char[8192];
        while ((read = reader.read(buffer)) != -1) {
            out.append(buffer, 0, read);
        }
        return out.toString();
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "InputStream must not be null");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.copy(inputStream, out);
        return out.toByteArray();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        Objects.requireNonNull(inputStream, "InputStream must not be null");
        Objects.requireNonNull(outputStream, "OutputStream must not be null");
        byte[] buffer = new byte[8192];
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        outputStream.flush();
    }
}

