/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons;

import com.github.nosan.embedded.cassandra.commons.FileSystemResource;
import com.github.nosan.embedded.cassandra.commons.Resource;
import com.github.nosan.embedded.cassandra.commons.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;

public class UrlResource
implements Resource {
    private final URL url;

    public UrlResource(URL url) {
        Objects.requireNonNull(url, "URL must not be null");
        this.url = url;
    }

    @Override
    public Optional<String> getFileName() {
        if (this.isFile()) {
            try {
                return this.getFile().getFileName();
            }
            catch (IOException ex) {
                return Optional.empty();
            }
        }
        String file = this.url.getFile();
        if (!StringUtils.hasText(file)) {
            return Optional.empty();
        }
        int lastIndexOf = file.lastIndexOf(47);
        return lastIndexOf != -1 ? Optional.of(file.substring(lastIndexOf + 1)) : Optional.of(file);
    }

    @Override
    public boolean exists() {
        if (this.isFile()) {
            try {
                return this.getFile().exists();
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.isReadable() || this.isWritable();
    }

    @Override
    public boolean isWritable() {
        try {
            if (this.isFile()) {
                return this.getFile().isWritable();
            }
            this.getOutputStream().close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        try {
            if (this.isFile()) {
                return this.getFile().isReadable();
            }
            this.getInputStream().close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isFile()) {
            return this.getFile().getInputStream();
        }
        URLConnection connection = this.url.openConnection();
        connection.setDoInput(true);
        return connection.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isFile()) {
            return this.getFile().getOutputStream();
        }
        URLConnection connection = this.url.openConnection();
        connection.setDoOutput(true);
        return connection.getOutputStream();
    }

    @Override
    public URL toURL() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UrlResource that = (UrlResource)other;
        return this.url.equals(that.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return "UrlResource{url=" + this.url + '}';
    }

    private boolean isFile() {
        return "file".equals(this.url.getProtocol());
    }

    private FileSystemResource getFile() throws IOException {
        return new FileSystemResource(Paths.get(this.toURI()));
    }
}

